<?php
return [
    // 'class' => 'yii\web\UrlManager',
    'enablePrettyUrl' => true,
    'enableStrictParsing' => true,
    'showScriptName' => false,
    'rules' =>
        \yii\helpers\ArrayHelper::merge(
        [
        ['pattern' => 'terms', 'route' => 'site/terms'],
        ['class' => 'yii\rest\UrlRule', 'controller' => 'contactus'
            , 'only' => ['create', 'support-contact-types' ,'options']
            , 'extraPatterns' => [
            'GET support-contact-types' => 'support-contact-types',
            'POST ' => 'create',
        ]
            , 'pluralize' => false,
        ],
        
        ['class' => 'yii\rest\UrlRule', 'controller' => 'notifications'
            , 'only' =>[ 'index', 'unseen','notification-list']
            , 'extraPatterns' => [
            'GET ' => 'index',
            'GET notification-list' => 'notification-list',
            'GET unseen' => 'unseen',
        ]
            , 'pluralize' => false,
        ],

        //User Data`
        ['class' => 'yii\rest\UrlRule', 'controller' => 'profile'
            , 'only' => ['index', 'update','change-password','change-location','verify', 'options','delete','logout','send-invitation']
            , 'extraPatterns' => [
            'GET index' => 'index',
            'POST verify' => 'verify',
            'POST change-password' => 'change-password',
            'POST change-location' => 'change-location',
            'PUT ' => 'update',
            'GET logout' => 'logout',
            'DELETE delete' => 'delete',
            'POST send-invitation' => 'send-invitation',
        ]
            , 'pluralize' => false,
        ],



        // Get Calls Token
        ['class' => 'yii\rest\UrlRule', 'controller' => 'calls'
            , 'only' => ['get-token']
            , 'extraPatterns' => [
            'POST get-token' => 'get-token',
        ]
            , 'pluralize' => false,
        ],

        ['class' => 'yii\rest\UrlRule', 'controller' => 'chat'
            , 'only' => [ 'index','create','send-message','send-resources','get-messages']
            , 'extraPatterns' => [
            'GET ' => 'index',
            'POST create' => 'create',
            'POST get-messages/' => 'get-messages',
            'POST send-message/' => 'send-message',
            'POST send-resources/' => 'send-resources',
        ]
            , 'pluralize' => false,
        ],        


        ['class' => 'yii\rest\UrlRule', 'controller' => 'user'
            , 'only' => ['send-verify','sign-in',  'verify', 'resend-otp', 'options','delete', 'test-sms']
            , 'extraPatterns' => [
            'POST send-verify' => 'send-verify',
            'POST sign-in' => 'sign-in',
            'POST verify' => 'verify',
            'POST resend-otp' => 'resend-otp',    
            
            'POST test-sms' => 'test-sms',     
        ]
            , 'pluralize' => false,
        ],

        ['class' => 'yii\rest\UrlRule', 'controller' => 'lookups'

            , 'only' => ['unit-type', 'services','city','packages-service','services-package','category','packages-service','nationality','shop-main-services', 'shop-service','service','education-levels', 'medical-conditions', 'skills', 'languages', 'settings']
            , 'extraPatterns' => [
            'GET education-levels' => 'education-levels',
            'GET medical-conditions' => 'medical-conditions',
            'GET skills' => 'skills',
            'GET service' => 'service',
            'GET shop-service' => 'shop-service',
            'GET category' => 'category',
            'GET city' => 'city',
            'GET packages-service' => 'packages-service',
            'GET shop-main-services' => 'shop-main-services',
            'GET services-package' => 'services-package',
            'GET nationality' => 'nationality',
            'GET languages' => 'languages',
            'GET settings' => 'settings',
        ]
            , 'pluralize' => false,
        ],

        ['class' => 'yii\rest\UrlRule', 'controller' => 'faq'
            , 'only' => ['create', 'delete', 'index', 'update', 'view'],
            'pluralize' => false,
        ],

        ['class' => 'yii\rest\UrlRule', 'controller' => 'content'
            , 'only' => ['terms-conditions']
            , 'extraPatterns' => [
            'GET terms-conditions' => 'terms-conditions',
        ]
            , 'pluralize' => false,
        ],

    ] ,
    require(__DIR__ . '/urls/_AgentUrls.php'),
    require(__DIR__ . '/urls/_CustomerUrls.php'),
        )
];
