<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use common\models\Ads;
use api\resources\AdsResource;
use yii\data\ActiveDataProvider;

class AdsController extends MyActiveController
{
    public $defaultPageSize= 12; // 20
    public $pageSize= 12;  // 50
    public $pageSizeLimit= [1,200];

    public $modelClass = AdsResource::class;
  
    public function beforeAction($action)
    {
        if(isset($_REQUEST['lang']) && $_REQUEST['lang']== 'ar'){
            \Yii::$app->language= 'ar';
        }
        return parent::beforeAction($action);
    }
    
    public function actionIndex()
    {
        $params = \Yii::$app->request->get();

        $query = AdsResource::find()->orderBy(['id'=>SORT_DESC]);
        $activeData = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'defaultPageSize' => $this->defaultPageSize , // to set default count items on one page
                'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
            ],
        ]);

        return $activeData;
    }
}