<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use api\models\BookingForm;
use api\modules\v1\resources\User;
use api\resources\AgentResource;
use api\resources\ExtendedBookingResource;
use api\resources\ExtendedBookingServicesResource;
use api\resources\AgentSlotsResource;
use api\resources\BookingResource;
use api\resources\FaqResource;
use api\resources\PackagesResource;
use api\resources\PreparingBookingResource;
use api\resources\SlotsResource;
use backend\models\Settings;
use common\models\AgentSlots;
use common\models\base\Booking;
use common\models\base\ExtendedBookingService;
use common\models\base\Package;
use common\models\base\Shop;
use common\models\base\ExtendedBooking;
use common\models\base\UserPackage;
use common\models\base\BookingService;
use common\models\Faq;
use common\models\Payment;
use common\models\Service;
use common\models\ShopService;
use common\models\UserShopService;
use yii\data\ActiveDataProvider;
use common\helpers\NotificationHelper;


class BookingController extends MyActiveController
{
    public $modelClass = Booking::class;
    public $pageSize= 50;  // 50
    public $defaultPageSize= 50; // 20

    public function beforeAction($action)
    {
        if (isset($_REQUEST['lang']) && $_REQUEST['lang'] == 'ar') {
            \Yii::$app->language = 'ar';
        }
        return parent::beforeAction($action);
    }


    public function actionIndex()
    {
        $params = \Yii::$app->request->get();

        $user = \common\models\User::findOne(\Yii::$app->user->getId());

        $query = BookingResource::find();
        $query->where(['customer_id' => $user->id])->orderBy(['id'=>SORT_DESC])
            ->andWhere(['>', 'status', Booking::STATUS_IN_PROGRESS]);

        if (isset($params['booking_date'])) {
            $query->andWhere(['booking_date' => $params['booking_date']]);
        }
        if (isset($params['old'])) {
            if ($params['old'] == 0) {
                // Include old and new items
                $query->andWhere(['>=', 'booking_date', date('Y-m-d')])
                    ->andWhere(['not in', 'status', [Booking::STATUS_CANCELED,Booking::STATUS_ENDED,Booking::STATUS_IN_SESSION,Booking::STATUS_CANCELED_BY_SHOP]]);

            } elseif ($params['old'] == 1) {
                // Include only old items when status = 0
                $query->andWhere(['or', ['<=', 'booking_date', date('Y-m-d')],
                    ['status' => [Booking::STATUS_CANCELED,Booking::STATUS_ENDED,Booking::STATUS_IN_SESSION,Booking::STATUS_CANCELED_BY_SHOP]]]);
            }
        }

        $activeData = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'defaultPageSize' => $this->defaultPageSize, // to set default count items on one page
                'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
            ],
        ]);
        return $activeData;
    }


    public function actionPreparingBooking()
    {
        $params = \Yii::$app->request->post();
        $model = new PreparingBookingResource();
        if ($model->load(['PreparingBookingResource' => $params]) && $model->validate()) {
            if (!$model->preparingWithPromoCode()) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);

            }
            return ResponseHelper::sendSuccessResponse($model);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
        }

    }

    public function actionBookingServices()
    {
//        with promo code
        $params = \Yii::$app->request->post();
        $model = new BookingForm();
        if ($model->load(['BookingForm' => $params]) && $model->validate()) {
            if (!$model->save()) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Shop Data')], 404);
            }
            $booking = BookingResource::findOne($model->booking_id);
            return ResponseHelper::sendSuccessResponse($booking);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
        }

    }

    public function actionScheduleBooking()
    {
        $params = \Yii::$app->request->post();

        if (isset($params['schedule_date']) && isset($params['services_ids'])) {

            $dayOfWeek = ((date('w', strtotime($params['schedule_date'])) + 1) % 7) + 1;
            $agentsIdsQuery = UserShopService::find()
                ->select('user_id')
                ->distinct()
                ->where(['service_id' => $params['services_ids']]);

            $agents = \common\models\User::find()
                ->leftJoin('user_profile', 'user.id = user_profile.user_id')
                ->andWhere(['user.id' => $agentsIdsQuery])
                ->andWhere(['OR', ['LIKE', 'user_profile.working_days', ',' . $dayOfWeek . ','],
                    ['LIKE', 'user_profile.working_days', $dayOfWeek . ','], ['LIKE', 'user_profile.working_days', ',' . $dayOfWeek]])->all();

            $slotsResources = [];

            foreach ($agents as $agent) {
                $agentId = $agent->id;

                $slots = AgentSlotsResource::findAll(['agent_id' => $agentId, 'booking_date' => $params['schedule_date']]);

                $slotsResource = new SlotsResource();
                $slotsResource->agent = AgentResource::findOne($agentId);
                $slotsResource->slots = $slots;

                $slotsResources[] = $slotsResource;
            }

///
            return ResponseHelper::sendSuccessResponse($slotsResources);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
        }

    }
    public function actionAgentSlots()
    {
        $params = \Yii::$app->request->post();

        if (isset($params['schedule_date']) && isset($params['agent_id'])) {

                $slots = AgentSlotsResource::findAll(['agent_id' => $params['agent_id'], 'booking_date' => $params['schedule_date']]);

                $slotsResource = new SlotsResource();
                $slotsResource->agent = AgentResource::findOne($params['agent_id']);
                $slotsResource->slots = $slots;

            return ResponseHelper::sendSuccessResponse($slotsResource);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
        }

    }

    public function actionBook()
    {
        $params = \Yii::$app->request->post();
        $model = new BookingForm();
        if ($model->load(['BookingForm' => $params])) {

            $booking = BookingResource::findOne($model->booking_id);
            if ($booking) {
                $booking->agent_id = $model->agent_id;
                $booking->booking_date = $model->schedule_date;
                $booking->from_hour = $model->from_hour;
                $booking->to_hour = $model->to_hour;
                $booking->status = Booking::STATUS_IN_PROGRESS;

//            Preparing agent slot
                if ($booking->save()) {

                    return ResponseHelper::sendSuccessResponse($booking);
                }
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);


    }

    public function actionPreparingBookingPackage()
    {
        $params = \Yii::$app->request->post();
        $model = new PreparingBookingResource();
        if ($model->load(['PreparingBookingResource' => $params])) {
            $package = PackagesResource::find()->where(['id' => $params['package_id']])->one();

            if (!$package || !$model->preparingPackageWithPromoCode($package)) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);

            }
            return ResponseHelper::sendSuccessResponse($model);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
        }

    }

    public function actionScheduleBookingPackage()
    {
        $params = \Yii::$app->request->post();
        if (isset($params['schedule_date']) && isset($params['package_id'])) {
            $package = Package::find()->where(['id' => $params['package_id']])->one();

            if (!$package) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
            }
            $dayOfWeek = ((date('w', strtotime($params['schedule_date'])) + 1) % 7) + 1;
            $agentsIdsQuery = UserPackage::find()
                ->select('user_id')
                ->distinct()
                ->where(['package_id' => $package->id]);

            $agents = \common\models\User::find()
                ->leftJoin('user_profile', 'user.id = user_profile.user_id')
                ->andWhere(['user.id' => $agentsIdsQuery])
                ->andWhere(['OR', ['LIKE', 'user_profile.working_days', ',' . $dayOfWeek . ','],
                    ['LIKE', 'user_profile.working_days', $dayOfWeek . ','], ['LIKE', 'user_profile.working_days', ',' . $dayOfWeek]])->all();

            $slotsResources = [];

            foreach ($agents as $agent) {
                $agentId = $agent->id;

                $slots = AgentSlotsResource::findAll(['agent_id' => $agentId, 'booking_date' => $params['schedule_date']]);

                $slotsResource = new SlotsResource();
                $slotsResource->agent = AgentResource::findOne($agentId);
                $slotsResource->slots = $slots;

                $slotsResources[] = $slotsResource;
            }

///
            return ResponseHelper::sendSuccessResponse($slotsResources);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
        }

    }

    public function actionBookPackageServices()
    {
        $params = \Yii::$app->request->post();
        $model = new BookingForm();
        if ($model->load(['BookingForm' => $params])) {
            $package = PackagesResource::find()->where(['id' => $params['package_id']])->one();

            if (!$package || !$model->preparingPackageWithPromoCode($package)) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
            }
            $booking = new Booking();
            $booking->mobile = UserController::$prefix . myClearPhone(\Yii::$app->user->identity->mobile);
            $booking->name = \Yii::$app->user->identity->full_name;
            $booking->email = \Yii::$app->user->identity->email;
            $booking->customer_id = \Yii::$app->user->getId();
            $booking->shop_id = $model->shop_id;
            $booking->discount_value = $model->promo_code_value;
            $booking->promo_code_id = $model->promo_code_id;
            $booking->vat = $model->vat;
            $booking->sub_amount = $model->amount;
            $booking->total_amount = $model->total_paid;
            $booking->total_with_extend = $model->total_paid;
            if ($booking->save(false)) {
                $services = ShopService::findAll($model->services_ids);
                if (!$services) {
                    return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
                }
                $model->preparingBookingServices($services, $booking);
                return ResponseHelper::sendSuccessResponse(BookingResource::findOne($booking->id));

            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);


    }

    //------------------ BookPackage ------------------------------

    public function actionBookPackage()
    {
        $params = \Yii::$app->request->post();
        $model = new BookingForm();
        if ($model->load(['BookingForm' => $params])) {

            $booking = BookingResource::findOne($model->booking_id);
            if ($booking) {
                $booking->agent_id = $model->agent_id;
                $booking->booking_date = $model->schedule_date;
                $booking->from_hour = $model->from_hour;
                $booking->to_hour = $model->to_hour;
                $booking->status = Booking::STATUS_IN_PROGRESS;

//            Preparing agent slot

//                $agentSlots = new AgentSlots();
//                $agentSlots->agent_id = $model->agent_id;
//                $agentSlots->booking_id = $model->booking_id;
//                $agentSlots->booking_date = $model->schedule_date;
//                $agentSlots->from_hour = $model->from_hour;
//                $agentSlots->to_hour = $model->to_hour;
                if ($booking->save()) {

                    return ResponseHelper::sendSuccessResponse($booking);
                }
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);


    }


    public function actionPay()
    {
        $params = \Yii::$app->request->post();

        if (isset($params['booking_id'], $params['invoice_id'],)) {
            $booking = BookingResource::findOne($params['booking_id']);
            if ($booking) {

                $booking->status = Booking::STATUS_PAID;
                $booking->invoice_id = $params['invoice_id'];
                if ($booking->save()) {

                    $agentSlots = new AgentSlots();
                    $agentSlots->agent_id = $booking->agent_id;
                    $agentSlots->booking_id = $booking->id;
                    $agentSlots->booking_date = $booking->booking_date;
                    $agentSlots->from_hour = $booking->from_hour;
                    $agentSlots->to_hour = $booking->to_hour;
                    $agentSlots->save();

                    $payment = new Payment();
                    $payment->booking_id = $booking->id;

                    // User data

                    $payment->user_id = $booking->customer_id;

                    // Session data

                    $payment->type = Payment::PAYMENT_TYPE_BOOKING;
                    $payment->tran_ref = $params['invoice_id'];

                    // Agent data
                    $payment->agent_id = $booking->agent_id;


                    // Payment data
                    $payment->amount = $booking->sub_amount- $booking->discount_value;
                    $payment->paid_amount = $booking->total_amount;

                    $payment->withdrawal = Payment::NOT_WITHDRAWED;
                    $payment->extended = Payment::PAYMENT_NOT_EXTENDED;
                    $payment->refunded = Payment::STATUS_NOT_REFUNDED;

                    if( !$payment->save()){
                        var_dump($payment->errors);
                    }

                    // calculate agent total services amount and count
                    $agent = \common\models\User::findOne($booking->agent_id);
                    $agent->services_count += $booking->getBookingServices()->count();
                    $agent->total_services_amount += (double)$booking->total_amount;
                    $agent->save();


                    NotificationHelper::instance()->newBooking($booking);

                    return ResponseHelper::sendSuccessResponse($booking);
                }
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);


    }

    public function actionView($id)
    {

        $booking = BookingResource::findOne($id);
        if ($booking) {
            return ResponseHelper::sendSuccessResponse($booking);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Not Found')], 404);
        }
    }

    public function actionTipping()
    {
        $params = \Yii::$app->request->post();

        if (isset($params['booking_id'], $params['tipping_amount'],$params['tipping_invoice_id'])) {
            $booking = BookingResource::findOne($params['booking_id']);

            if ($booking) {
                $booking->tipping_amount = $params['tipping_amount'];
                $booking->tipping_status = Booking::STATUS_PAID;
                $booking->tipping_invoice_id = $params['tipping_invoice_id'];

                $payment = new Payment();
                $payment->booking_id = $booking->id;

                // User data
                $payment->user_id = $booking->customer_id;

                // Session data
                $payment->type = Payment::PAYMENT_TYPE_TIPPING;
                $payment->tran_ref = $params['tipping_invoice_id'];

                // Agent data
                $payment->agent_id = $booking->agent_id;

                // Payment data
                $payment->amount = $booking->tipping_amount;
                $payment->paid_amount = $booking->tipping_amount;

                $payment->withdrawal = Payment::NOT_WITHDRAWED;
                $payment->extended = Payment::PAYMENT_NOT_EXTENDED;
                $payment->refunded = Payment::STATUS_NOT_REFUNDED;

                if( !$payment->save()){
                    var_dump($payment->errors);
                }

                if ($booking->save())
                {
                    NotificationHelper::instance()->sendTippingToAgent($booking);

                    // calculate agent total tippings amount and count
                    $agent = \common\models\User::findOne($booking->agent_id);
                    $agent->tippings_count += 1;
                    $agent->total_tippings_amount += $booking->tipping_amount;
                    $agent->save();

                    return ResponseHelper::sendSuccessResponse($booking);
                }
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
    }



    public function actionPayTipping()
    {
        $params = \Yii::$app->request->post();
        if (isset($params['booking_id'], $params['tipping_invoice_id'],)) {
            $booking = BookingResource::findOne($params['booking_id']);
            if ($booking) {
                $booking->tipping_status = Booking::STATUS_PAID;
                $booking->tipping_invoice_id = $params['tipping_invoice_id'];
                if ($booking->save()) {
                    return ResponseHelper::sendSuccessResponse($booking);
                }
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);


    }

    public function actionUpdateStatus()
    {
        $params = \Yii::$app->request->post();
        if (isset($params['booking_id'], $params['status'],)) {

            $booking = Booking::find()->where(['id' => $params['booking_id'], 'customer_id' => \Yii::$app->user->getId()])->one();

            if ($booking)
            {
                $booking->status = $params['status'];
                if ($params['status']==Booking::STATUS_CANCELED)
                {
                    NotificationHelper::instance()->customerCancelBooking($booking);

                    $booking->reason = $params['reason'];
                }
                $booking->save();

                return ResponseHelper::sendSuccessResponse(['MESSAGE' => \Yii::t('backend', 'Your request has been updated successfully')], 200);
            }
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'The request is not found')], 400);

        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);

    }

    public function actionExtendedBookings()
    {
        $params = \Yii::$app->request->get();
        $user = \common\models\User::findOne(\Yii::$app->user->getId());

        $query = ExtendedBookingResource::find();
        $query->where(['customer_id' => $user->id]);

        if (isset($params['booking_date'])) {
            $query->andWhere(['booking_date' => $params['booking_date']]);
        }

        if (isset($params['old'])) {
            if ($params['old'] == 0) {
                // Include old and new items
                $query->andWhere(['>', 'booking_date', date('Y-m-d')]);
            } elseif ($params['old'] == 1) {
                // Include only old items when status = 0
                $query->andWhere(['or', ['<', 'booking_date', date('Y-m-d')], ['status' => Booking::STATUS_CANCELED]]);
            }
        }

        $activeData = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'defaultPageSize' => $this->defaultPageSize, // to set default count items on one page
                'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
            ],
        ]);
        return $activeData;
    }


    public function actionAcceptExtendedBooking()
    {
        $params = \Yii::$app->request->post();

        if (isset($params['booking_id'])) {
            $booking = ExtendedBookingResource::findOne($params['booking_id']);
            if ($booking)
            {

                $extendedServices = ExtendedBookingService::find()->where(['booking_id' => $booking->id])
                    ->andWhere(['not in', 'service_id', $params['services_id']])
                    ->all();

                if ($extendedServices)
                {
                    foreach ($extendedServices as $extendedService) {

                        $booking->sub_amount-=$extendedService->service->service_amount;
                        $booking->to_hour= $this->subtractMinutesFromTime( $booking->to_hour, $extendedService->service->service_period);
                        $extendedService->delete();
                    }
                    $booking->total_amount=(double)$booking->sub_amount + (double)$this->vat($booking->sub_amount)-(double)$booking->discount_value;

                }
                $booking->status = ExtendedBooking::STATUS_ACCEPTED;

                $booking->save();

                return ResponseHelper::sendSuccessResponse($booking);
            }
        }

        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
    }
    public function vat($amount)
    {
        $settings = Settings::findOne(1);

        if ($settings->taxes_type == Settings::SERVICE_FEE_TYPE_FIXED) {
           return $settings->taxes;

        } else {
            return ($amount *  $settings->taxes  / 100);
        }

    }
  private  function subtractMinutesFromTime($time, $minutesToSubtract) {

      list($hour, $minute) = explode(':', $time);
      $hour = (int)$hour; // Cast to integer
      $minute = (int)$minute; // Cast to integer
      $timeInMinutes = ($hour * 60) + $minute;

      $timeInMinutes -= $minutesToSubtract;

      if ($timeInMinutes < 0) {
          $timeInMinutes = 0;
      }

      $newHour = floor($timeInMinutes / 60);
      $newMinute = $timeInMinutes % 60;

      $newTime = sprintf('%02d:%02d', $newHour, $newMinute);

      return $newTime;
    }

    public function actionPayExtendedBooking()
    {
        $params = \Yii::$app->request->post();

        if (isset($params['booking_id'], $params['invoice_id'])) {
            $booking = ExtendedBookingResource::findOne($params['booking_id']);
            if ($booking)
            {
                $booking->status = ExtendedBooking::STATUS_PAID;
                $booking->invoice_id = $params['invoice_id'];
                if ($booking->save())
                {
                    $extendedServices = ExtendedBookingServicesResource::find()->where(['booking_id' => $booking->id])->all();

                    foreach($extendedServices as $service)
                    {
                        $booking_service = new BookingService;
                        $booking_service->service_id = $service->service_id;
                        $booking_service->booking_id = $booking->booking_id;
                        $booking_service->extended_id = $service->booking_id;

                        $booking_service->save();
                    }

                    // save new booking time
                    $booking_ob =Booking::findOne( $booking->booking_id);
                    $booking_ob->to_hour =$booking->to_hour;
                    $booking_ob->sub_amount+=(double)$booking->sub_amount;
                    $booking_ob->vat = $this->vat(($booking_ob->sub_amount-$booking->discount_value));
                    $booking_ob->total_amount=(double)$booking_ob->sub_amount + $booking_ob->vat;
                    $booking_ob->save();

                    // save new slot time
                    $agentSlots = AgentSlots::find()->where(['booking_id'=>$booking->booking_id,])->one();
                    $agentSlots->to_hour = $booking->to_hour;
                    $agentSlots->save();

                    $payment = new Payment();
                    $payment->booking_id = $booking->id;

                    // User data
                    $payment->user_id = $booking->customer_id;

                    // Session data

                    $payment->type = Payment::PAYMENT_TYPE_EXTENDED;
                    $payment->tran_ref = $params['invoice_id'];

                    // Agent data
                    $payment->agent_id = $booking->agent_id;


                    // Payment data
                    $payment->amount = $booking->sub_amount - $booking->discount_value;
                    $payment->paid_amount = $booking->total_amount;

                    $payment->withdrawal = Payment::NOT_WITHDRAWED;
                    $payment->extended = Payment::PAYMENT_EXTENDED;
                    $payment->refunded = Payment::STATUS_NOT_REFUNDED;

                    if( !$payment->save()){
                        var_dump($payment->errors);
                    }

                    // calculate total with extend booking
                    $mainBooking = BookingResource::findOne($booking->booking_id);
                    $mainBooking->total_with_extend = $mainBooking->total_amount + $booking->total_amount;
                    $mainBooking->save();

                    NotificationHelper::instance()->payExtendBooking($booking);

                    return ResponseHelper::sendSuccessResponse($booking);
                }
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
    }


    public function actionExtendedBooking($id)
    {
        $booking = ExtendedBookingResource::findOne($id);
        if ($booking) {
            return ResponseHelper::sendSuccessResponse($booking);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Not Found')], 404);
        }
    }


}