<?php

namespace api\controllers;

use api\helpers\ImageHelper;
use api\helpers\ResponseHelper;
use api\modules\v1\resources\User;
use api\resources\ChatResource;
use api\resources\UserResource;
use common\models\Booking;
use common\models\Conversation;
use common\models\Message;
use common\helpers\NotificationHelper;
use Yii;
use yii\base\InvalidParamException;
use yii\web\UploadedFile;

class ChatController extends MyActiveController
{
    public $modelClass = Conversation::class;

    public function actionIndex()
    {
        $user = User::find()->where(['id' => \Yii::$app->user->identity->getId()])->one();
        $type = $user->user_type == User::USER_TYPE_CUSTOMER ? 'conversation.customer_id' : 'conversation.agent_id';

        $chats = ChatResource::find()
            ->joinWith(['booking'])
            ->where(['in', 'booking.status', [Booking::STATUS_PAID, Booking::STATUS_IN_SESSION]])
            ->andWhere([ $type => \Yii::$app->user->identity->getId()])
            ->andWhere(['IS NOT', 'booking.customer_id', null])
            ->orderBy(['id' => SORT_ASC])
            ->all();

        if($chats){
            return ResponseHelper::sendSuccessResponse($chats);
        }else{
            return ResponseHelper::sendSuccessResponse([]);
        }

    }

    public function actionSendMessage()
    {
        $params = \Yii::$app->request->post();;
        $user = User::find()->where(['id' => \Yii::$app->user->identity->getId()])->one();
        $type = $user->user_type == User::USER_TYPE_CUSTOMER ? 'customer_id' : 'agent_id';

        $conversation = Conversation::find()
            ->where(['id' => $params['conversation_id'], $type => \Yii::$app->user->identity->getId()])
            ->one();
        if (!$conversation) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Your request was made with invalid credentials.'], 400);
        }
        $message = new Message();
        $message->sender_id = \Yii::$app->user->identity->getId();


        if (!$message->load(['Message' => $params])) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Conversation ID, sender ID, and message cannot be empty.'], 400);
        }
        $message->type = Message::MESSAGE_TYPE_TEXT;
        $message->seen = Message::MESSAGE_NOT_SEEN;


        if ($message->save()) {

            $conversation->last_update = time();
            if (!$conversation->save()) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Failed to create conversation.'], 400);
            } else {

                NotificationHelper::instance()->NewChatMessage($message->id);

                return ResponseHelper::sendSuccessResponse('Message sent successfully');
            }
        } else {
            return ['success' => false, 'message' => 'Failed to send message.'];
        }
    }
    public function actionGetMessages()
    {

        $params = \Yii::$app->request->post();
        $booking_id = $params['booking_id'];
        $user = \common\models\User::findOne(\Yii::$app->user->getId());
//        if ($user->user_type > 0) {
//            $booking_temp = Booking::findOne($params['booking_id']);
//            $booking_id = $booking_temp->id;
//        }
        $type = $user->user_type == User::USER_TYPE_CUSTOMER ? 'customer_id' : 'agent_id';


        $booking = Booking::find()
            ->where(['id' => $booking_id,$type => \Yii::$app->user->identity->getId(),
                'status' => [Booking::STATUS_PAID,
                    Booking::STATUS_IN_SESSION
                ]])
            ->andWhere(['IS NOT', 'customer_id', null])
            ->one();


        if (!$booking) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Your request was made with invalid credentials booking id: ' . $booking_id], 400);
        }

        $conversation = Conversation::find()
            ->where(['booking_id' => $booking->id, 'customer_id' => $booking->customer_id,
                'agent_id' => $booking->agent_id])
            ->one();

        if (!$conversation) {
            $conversation = new Conversation();
            $conversation->agent_id = $booking->agent_id;
            $conversation->customer_id = $booking->customer_id;
            $conversation->booking_id = $booking->id;
            if ($conversation->save()) {
                $conversation = ChatResource::findOne($conversation->id);
                Message::updateAll(['seen' => Message::MESSAGE_SEEN], ['=', 'conversation_id',$conversation->id]);

                return ResponseHelper::sendSuccessResponse($conversation);
            } else {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Failed to create conversation.'], 400);
            }
        }


        $messages = ChatResource::findOne($conversation->id);


        if ($messages) {
            Message::updateAll(['seen' => Message::MESSAGE_SEEN], ['=', 'conversation_id',$messages->id]);
            return ResponseHelper::sendSuccessResponse($messages);
        } else {
            return ['success' => false, 'message' => 'Failed to get messages.'];
        }
    }

    public function actionSendResources()
    {
        $params = \Yii::$app->request->post();;
        $user = User::find()->where(['id' => \Yii::$app->user->identity->getId()])->one();
        $type = $user->user_type == User::USER_TYPE_CUSTOMER ? 'customer_id' : 'agent_id';

        $conversation = Conversation::find()
            ->where(['id' => $params['conversation_id'], $type => \Yii::$app->user->identity->getId()])
            ->one();
        if (!$conversation) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Your request was made with invalid credentials.'], 400);
        }
        $message = new Message();
        $message->sender_id = \Yii::$app->user->identity->getId();
        if (!$message->load(['Message' => $params])) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Conversation ID, sender ID, and message cannot be empty.'], 400);
        }


        if ($params['image'] !== null) {
            try {
                $filename = ImageHelper::Base64Image($params['image'],'chat/' . $params['conversation_id']);
                $baseDir = \Yii::getAlias('@storageUrl') .'/source/'. 'chat/' . $params['conversation_id'];
                $message->image_base_url = $baseDir . '/' . $filename;
                $message->type = Message::MESSAGE_TYPE_IMAGE;
            } catch (InvalidParamException $e) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => $e->getMessage()], 400);
            }
        }


        if ($message->save()) {

            $conversation->last_update = time();
            if (!$conversation->save()) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Failed to create conversation.'], 400);
            } else {

//                NotificationHelper::instance()->NewChatMessage($message->id);

                return ResponseHelper::sendSuccessResponse('Message sent successfully');
            }
        } else {
            return ['success' => false, 'message' => 'Failed to send message.'];
        }
    }





}

