<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use api\modules\v1\resources\User;
use backend\models\Contact;
use backend\models\ContactUs;
use backend\models\FaqCat;
use backend\models\Settings;
use common\helpers\EmailHelper;
use Yii;
use yii\rest\ActiveController;

class ContactusController extends MyActiveController
{
    public $defaultPageSize= 100; // 20
    public $pageSize= 100;  // 50
    public $pageSizeLimit= [1,200];

    public function actions(){
        $actions = parent::actions();
        unset($actions['index']);
        unset($actions['view']);
        unset($actions['create']);
        unset($actions['update']);
        unset($actions['delete']);
        return $actions;
    }


    public $modelClass = ContactUs::class;

    public function actionSupportContactTypes()
    {


        $types = ContactUs::contactTypesList();

        foreach($types as $index => $cat){
            $data[] =[ 'id'=>$index , 'title'=>$cat ];

        }
        return ResponseHelper::sendSuccessResponse($data);
    }

    public function actionCreate()
    {
        $params = \Yii::$app->request->post();
        $user = User::findOne(\Yii::$app->user->getId());
        $model = new ContactUs();
        $params['user_id'] = $user->id;
        $params['name'] = $user->full_name;
        $params['phone'] = $user->mobile;
        $params['email'] = $user->email;

//        return $user_id;
        if($model->load(['ContactUs'=>$params]) &&$model->validate()){ // &&
            /*$foundCount = ContactUs::find()->where(['and', ['email' => $model->email], ['>=', 'created_at', date('Y-m-d')]])
                ->orWhere(['and', ['name' => $model->name], ['>=', 'created_at', date('Y-m-d')]])
                ->count();

            if ($foundCount >= 3) {
                return ResponseHelper::sendSuccessResponse([]);
            }*/
            $model->save() ;
                        //send email to admin
//            $settingObj= Settings::find()->one();
//            $message = 'A new Contact message has been received ';
//            EmailHelper::instance()->SendWelcome($settingObj->notification_email,$message);
//            //send email to client
//            EmailHelper::instance()->SendWelcome($model->email , 'Your request has been received');


            return ResponseHelper::sendSuccessResponse('Your request has been sent successfully');
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>$model->errors],400);
        }


    }


}