<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use api\resources\FaqResource;
use common\models\Faq;

class FaqController extends MyActiveController
{
    public $modelClass = Faq::class;    
    public function beforeAction($action)
    {
        if(isset($_REQUEST['lang']) && $_REQUEST['lang']== 'ar'){
            \Yii::$app->language= 'ar';
        }
        return parent::beforeAction($action);
    }
    public function actionIndex()
    {
        $FAQObj = FaqResource::find()->orderBy(['sort' => SORT_ASC])->all();

        if($FAQObj){
            return ResponseHelper::sendSuccessResponse($FAQObj);
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Not Found')], 404);
        }

    }

}