<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use api\resources\CategoryResource;
use api\resources\CityResource;
use api\resources\EducationLevelResource;
use api\resources\MedicalConditionResource;
use api\resources\NationalityResource;
use api\resources\PackagesResource;
use api\resources\PackagesServiceResource;
use api\resources\ServiceResource;
use api\resources\ShopMainServicesResource;
use api\resources\ShopServiceResource;
use api\resources\SkillResource;
use api\resources\LanguageResource;
use backend\models\Settings;
use common\helpers\NotificationHelper;
use common\models\base\Shop;
use common\models\base\ShopService;
use common\models\PackagesService;
use common\models\Service;

class LookupsController extends MyRestController
{    
    public function beforeAction($action)
    {
        if(isset($_REQUEST['lang']) && $_REQUEST['lang']== 'ar'){
            \Yii::$app->language= 'ar';
        }
        return parent::beforeAction($action);
    }
    
    public function actionEducationLevels()
    {
        $params = \Yii::$app->request->get();

        $educationLevelsObj = EducationLevelResource::find()->all();

        if($educationLevelsObj){
            return ResponseHelper::sendSuccessResponse($educationLevelsObj);
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>'Not Found'],404);
        }
    }


    public function actionMedicalConditions()
    {
        $params = \Yii::$app->request->get();

        $medicalConditionsObj = MedicalConditionResource::find()->all();

        if($medicalConditionsObj){
            return ResponseHelper::sendSuccessResponse($medicalConditionsObj);
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>'Not Found'],404);
        }
    }


    public function actionSkills()
    {
        $params = \Yii::$app->request->get();
    
        $skillsObj = SkillResource::find()->all();

        if($skillsObj){
            return ResponseHelper::sendSuccessResponse($skillsObj);
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>'Not Found'],404);
        }
    }
    public function actionCategory()
    {
        $params = \Yii::$app->request->get();


        $categoryObj = CategoryResource::find()->all();
        if (isset($params['id']))
            $categoryObj = CategoryResource::find()->where(['id'=>$params['id']])->one();

        return ResponseHelper::sendSuccessResponse($categoryObj);

    }    public function actionCity()
    {
        $categoryObj = CityResource::find()->all();

            return ResponseHelper::sendSuccessResponse($categoryObj);

    }
    public function actionService()
    {
        $params = \Yii::$app->request->get();

        $serviceObj = ServiceResource::find()->where(['category_id'=>$params['category_id']])->all();


            return ResponseHelper::sendSuccessResponse($serviceObj);

    }
    public function actionShopMainServices()
    {
        $params = \Yii::$app->request->get();
        $shopMainServices = ShopMainServicesResource::find()->where(['shop_id'=>$params['shop_id']])->joinWith('service')->groupBy('service_id')->select('service.id,service.name,shop_service.service_id,COUNT(*) as services_count')->all();
        return ResponseHelper::sendSuccessResponse($shopMainServices);
    }
    public function actionShopService()
    {
        $params = \Yii::$app->request->get();

        $serviceObj = ShopServiceResource::find()->where(['service_id'=>$params['service_id'],'shop_id'=>$params['shop_id']])->all();


            return ResponseHelper::sendSuccessResponse($serviceObj);

    }
    public function actionPackagesService()
    {
        $params = \Yii::$app->request->get();

        $serviceObj = PackagesResource::find()->where(['shop_id'=>$params['shop_id']])->all();


            return ResponseHelper::sendSuccessResponse($serviceObj);

    }
    public function actionServicesPackage($package_id)
    {
        $params = \Yii::$app->request->get();


        $serviceObj = PackagesServiceResource::findOne($params['package_id']);


            return ResponseHelper::sendSuccessResponse($serviceObj);

    }

    public function actionLanguages()
    {
        $params = \Yii::$app->request->get();
        
        $languagessObj = LanguageResource::find()->all();

            return ResponseHelper::sendSuccessResponse($languagessObj);

    }
    public function actionNationalities()
    {
        $params = \Yii::$app->request->get();

        $nationalityObj = NationalityResource::find()->all();

            return ResponseHelper::sendSuccessResponse($nationalityObj);

    }

    public function actionSettings()
    {

        $settingsobj = Settings::findOne(1);
        $settings = [

            'terms_conditions'=>$settingsobj->terms_conditions,
            'vat'=>intval($settingsobj->taxes)?:0,
            'vat_type'=>intval($settingsobj->taxes_type)?:0,
            'tipping_amount_v1'=>10,
            'tipping_amount_v2'=>15,
            'tipping_amount_v3'=>30,

        ];
        return ResponseHelper::sendSuccessResponse($settings);
    }

    public function actionSend(){
        NotificationHelper::instance()->NewRequest();
    }

}