<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use api\resources\NotificationsResource;
use api\resources\UserResource;
use common\models\base\ExtendedBooking;
use yii\base\Model;
use yii\data\ActiveDataProvider;

use common\models\base\Notifications;


class NotificationsController extends MyActiveController
{
    public $defaultPageSize = 12; // 20
    public $pageSize = 12;  // 50
    public $pageSizeLimit = [1, 200];

    public $modelClass = NotificationsResource::class;

    public function beforeAction($action)
    {
        if (isset($_REQUEST['lang']) && $_REQUEST['lang'] == 'ar') {
            \Yii::$app->language = 'ar';
        }
        return parent::beforeAction($action);
    }

    public function actionIndex()
    {
        $user = UserResource::findOne(\Yii::$app->user->identity->getId());

        $query = NotificationsResource::find()->orderBy(['id' => SORT_DESC]);
        $query->where(['to_id' => $user->id]);

        $activeData = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'defaultPageSize' => $this->defaultPageSize, // to set default count items on one page
                'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
            ],
        ]);

        Notifications::updateAll(['seen' => Notifications::NOTIFICATION_SEEN], ['=', 'to_id', $user->id]);

        return $activeData;

    }

    public function actionNotificationList()
    {
        $user = UserResource::findOne(\Yii::$app->user->identity->getId());

        $extendBookings = ExtendedBooking::find()->orderBy(['id' => SORT_DESC])->where(['customer_id' => $user->id])->all();

        $notifications = [];

        foreach ($extendBookings as $extendBooking) {
            $notification = new NotificationsResource();

            $notification = new NotificationsResource();
            $notification->id = $extendBooking->id;
            $notification->key_id = 1;
            $notification->topic = null;
            $notification->from_id =$extendBooking->agent->id;
            $notification->to_id =$extendBooking->customer->id;
            $notification->module = "extend";
            $notification->module_id = $extendBooking->id;
            $notification->title_ar = "اضافة خدمات الي الحجز";
            $notification->title_en = "Add services to the Booking";
            $notification->message_ar =   " يطلب زيادة خدمات الي الحجز ".$extendBooking->agent->full_name;
            $notification->message_en = $extendBooking->agent->full_name . " requests an increase in reservation services. " ;
            $notification->request_id = $extendBooking->booking_id;
            $notification->action = null;
            $notification->seen = 0;
            $notification->route = "extendDetails";

//            $notification->request_status = $extendBooking->status;
//            $notification->tracking_status = null;
//            $notification->request_tracking_log = null;
//            $notification->extend_request_status = null;

            // Add the NotificationsResource object to the array
            $notifications[] = $notification;
        }
        return $notifications;

    }

    public function actionUnseen()
    {
        $user = UserResource::findOne(\Yii::$app->user->identity->getId());

        $unseen_notifications_count = Notifications::find()->where(['seen' => Notifications::NOTIFICATION_NOT_SEEN, 'to_id' => $user->id])->count();

        return ResponseHelper::sendSuccessResponse(['unseen_notifications_count' => $unseen_notifications_count], 200);
    }

}