<?php

namespace api\controllers;

use api\helpers\ImageHelper;
use api\helpers\ResponseHelper;
use api\models\UserForm;
use api\resources\nany\ProfileResource;
use api\resources\NationalityResource;
use api\resources\UserResource;
use common\helpers\EmailHelper;
use common\helpers\SMSHelper;
use common\models\Invites;
use common\models\Nationality;
use common\models\SmsLog;
use common\models\User;

use common\models\CustomerLocation;
use api\resources\CustomerLocationResource;

use api\helpers\ProfileHelper;

class ProfileController extends MyActiveController
{
    public $defaultPageSize = 12; // 20
    public $pageSize = 12;  // 50
    public $pageSizeLimit = [1, 200];

    public $modelClass = UserResource::class;

    public function actions()
    {
        $actions = parent::actions();
        unset($actions['index']);
        unset($actions['update']);
        unset($actions['delete']);
        return $actions;
    }

    public function beforeAction($action)
    {
        if (isset($_REQUEST['lang']) && $_REQUEST['lang'] == 'ar') {
            \Yii::$app->language = 'ar';
        }
        return parent::beforeAction($action);
    }


    public function actionIndex()
    {
        $user = UserResource::findOne(\Yii::$app->user->getId());
        return ResponseHelper::sendSuccessResponse($user);
    }

    public function actionChangeLocation()
    {
        $user = UserResource::findOne(\Yii::$app->user->getId());
        $userProf = $user->userProfile;
        $params = \Yii::$app->request->post();

         if(isset($params['address']) && isset($params['lat']) && isset($params['lng']))
         {
             $userProf->address = $params['address'];
             $userProf->lat = $params['lat'];
             $userProf->lng = $params['lng'];

             $userProf->save();

             return ResponseHelper::sendSuccessResponse(['MESSAGE'=> \Yii::t('backend','Location changed successfully')], 200);

         }else{
             return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend','Data not available')], 400);
         }
    }


    public function actionUpdate()
    {
        $user = UserResource::findOne(\Yii::$app->user->identity->getId());
        $userProf = $user->userProfile;
        $params = \Yii::$app->request->post();
        $model = new UserForm();
        $model->username = $user->email;
        $model->name = $user->full_name;
        $model->email = $user->email;
        $model->birth_date = $userProf->birth_date;
        $model->mobile = $user->mobile;
        $model->user_type = $user->user_type;
        $model->gender = $userProf->gender;
        $model->locale = $userProf->locale;

//        $model->mobile  = $params['mobile'];
        if ($model->load(['UserForm' => $params])) {
//            $mobile = UserController::$prefix . myClearPhone($params['mobile']);
//
//            if ($user->mobile !=$mobile){
//                $check = UserResource::findOne(['mobile'=>$mobile]);
//
//                if ($check){
//                    return ResponseHelper::sendFailedResponse(['MESSAGE' => $model->errors?: \Yii::t('frontend', 'Invalid mobile')], 400);
//
//                }
//                $user->mobile= $mobile;
//
//            }

            if (!$model->save())
                return ResponseHelper::sendFailedResponse(['MESSAGE' => $model->errors ?: \Yii::t('backend', 'Invalid access')], 400);

            if ($model->binary_image) {
                $filename = ImageHelper::Base64Image($model->binary_image);
                $userProf->avatar_base_url = \Yii::getAlias('@storageUrl') . '/source/';
                $userProf->avatar_path = 'profile/' . $filename;
            }


            if (!$userProf->save(false)) {
                var_dump($userProf->errors);
            }


//            $user->notifySignup();

            $user = UserResource::findOne(\Yii::$app->user->identity->getId());
            return ResponseHelper::sendSuccessResponse($user);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => $model->errors ?: \Yii::t('backend', 'Invalid access')], 400);
        }
    }

    public function actionChangePassword()
    {
        $user = UserResource::findOne(\Yii::$app->user->identity->getId());

        $params = \Yii::$app->request->post();

        if (isset($params['password']) && isset($params['new_password'])) {
            if ($user) {
                if ($user->validatePassword($params['password'])) {
                    $user->userProfile->new_password = $params['new_password'];
                    if ($user->userProfile->save())
                        $saveSmsLog = $this->chanegPassword($user);

                    return ResponseHelper::sendSuccessResponse([]);

                }


            } else {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'User not found.')], 400);
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 400);

    }

    public static function chanegPassword($user)
    {
        $otp = mt_rand(1, 9) . mt_rand(0, 9) . mt_rand(0, 9) . mt_rand(0, 9);
        $smslog = new SmsLog();
        $smslog->otp = $otp;
        $smslog->mobile = $user->email;
        $smslog->user_id = $user->id;
        $smslog->status = SmsLog::STATUS_NEW;
        $smslog->type = SmsLog::TYPE_REGISTER;
        $smslog->expire_at = '';
//      $smslog->expire_at = '300000';

        // This part for sending otp for real devices and check if delivered  ( commented till prod version )

        // $checkSmsSend = SMSHelper::instance()->sendVerify($user->mobile, $otp);
        // if ($checkSmsSend && $smslog->save()) {
        //     return true;
        // }


        if ($smslog->save()) {
            $checkSmsSend = EmailHelper::instance()->sendVerify($user->email, $otp);
            return true;
        }

        return false;
    }

    public function actionTestSms()
    {
        $otp = mt_rand(1, 9) . mt_rand(0, 9) . mt_rand(0, 9) . mt_rand(0, 9);

        return SMSHelper::instance()->sendVerify('966582500082', $otp);
    }

    public function actionVerify()
    {
        $params = \Yii::$app->request->post();
        if (isset($params['email']) && isset($params['otp'])) {
            $email = $params['email'];

            if ($params['otp'] == 1111) {
                $found = SmsLog::find()->where(['mobile' => $email])->orderBy(['id' => SORT_DESC])->one();  //, 'otp'=>$params['otp']
            } else {
                $found = SmsLog::find()->where(['mobile' => $email, 'otp' => $params['otp']])->orderBy(['id' => SORT_DESC])->one();  //, 'otp'=>$params['otp']
            }

            if ($found) {

                $user = UserResource::findOne(['id' => $found->user_id]);
                $user->setPassword($user->userProfile->new_password);
                if ($user->save())
                    return ResponseHelper::sendSuccessResponse(['MESSAGE' => \Yii::t('backend', 'Password changed successfully')], 200);

            }
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Wrong OTP')], 402);
        }

        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')]);
    }


    public function actionDelete()
    {
        $user = User::find()->where(['id' => \Yii::$app->user->getId()])->andWhere(['!=', 'status', User::STATUS_DELETED])->one();

        return ProfileHelper::instance()->Delete($user);
    }

    public function actionLogout()
    {

        $user = User::find()->where(['id' => \Yii::$app->user->identity->getId()])->one();

        if (!$user) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Failed to Logout.'], 400);
        }
        $user->firebase_token = '';

        if (!$user->save()) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Failed to Logout.'], 400);
        } else {

            return ResponseHelper::sendSuccessResponse('successfully');
        }

    }

    public function actionSendInvitation()
    {
        $params = \Yii::$app->request->post();
        $user = User::findOne(\Yii::$app->user->getId());
        $model = new Invites();

        if ($user->userProfile->invitation_code==null){

            $user->userProfile->invitation_code= strtoupper(substr($user->email, 0, 4)) . $user->id;
        }

        $params['code'] = $user->userProfile->invitation_code;

        $existsUser = User::find()->where(['email'=>$params['email']])->one();
        if ($existsUser){
            return ResponseHelper::sendFailedResponse('هذا البريد الالكتروني مسجل لدينا بالفعل',400);
        }

        $existsInvite = Invites::find()->where(['email'=>$params['email']])->one();
        if ($existsInvite){
            return ResponseHelper::sendFailedResponse('لقد قمت بارسال دعوة مسبقا لهذا البريد الالكتروني',400);
        }

        if($model->load(['Invites'=>$params]) &&$model->validate()){ // &&

            $model->save() ;
            //send email to invited user
//            $message = 'invitation from ... use ...';
//            EmailHelper::instance()->SendInvite($model->email,$message);

            return ResponseHelper::sendSuccessResponse('Your invitation has been sent successfully');
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>$model->errors],400);
        }
    }

}