<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use api\resources\RateResource;
use api\resources\RequestRateResource;
use api\resources\UserResource;
use common\models\base\Shop;
use common\models\Booking;
use common\models\Rate;
use common\models\User;
use common\helpers\NotificationHelper;
use Yii;

class RateController extends MyActiveController
{
    public $modelClass = Rate::class;

    public function beforeAction($action)
    {
        if(isset($_REQUEST['lang']) && $_REQUEST['lang']== 'ar'){
            \Yii::$app->language= 'ar';
        }
        return parent::beforeAction($action);
    }

    /**
     * Lists all rates related to a specific customer.
     */
    public function actionIndex()
    {
        $rates = RateResource::find()
            ->where(['user_id' => \Yii::$app->user->getId()])
            ->all();
        return ResponseHelper::sendSuccessResponse($rates);
    }

    public function actionById($id)
    {
        $rates = RateResource::find()
            ->where(['user_id' => $id])
            ->all();
        return ResponseHelper::sendSuccessResponse($rates);
    }

    public function actionShop($id)
    {
        $rates = RateResource::find()
            ->where(['user.shop_id' => $id])
            ->leftJoin('user', 'rate.user_id = user.id')
            ->select(['rate.*','user.shop_id'])            
            ->all();
        return ResponseHelper::sendSuccessResponse($rates);
    }


    /**
     * Displays the rating form for the client.
     */
    public function actionCreate()
    {
        $params = \Yii::$app->request->post();

        $user = UserResource::findOne(\Yii::$app->user->getId());

        if($user->user_type == 0){
            $check = Booking::find()
            ->where([
                'id' => $params['request_id'],
                // 'request_tracking_status' => CustomerRequest::REQUEST_TRACKING_STATUS_ENDED
            ])->andWhere([ 'customer_id' => $user->id ])
            ->one();
        }else{  
            $check = Booking::find()
            ->where([
                'id' => $params['request_id'],
                // 'request_tracking_status' => CustomerRequest::REQUEST_TRACKING_STATUS_ENDED
            ])->andWhere([ 'agent_id' => $user->id ])
            ->one();
        }
        
        if ($check) 
        {
            $IfRated = RateResource::find()
                ->where(['request_id' => $params['request_id'], 'created_by' => $user->id])
                ->one();

            if (!$IfRated) 
            {
                $rate = new Rate();
                if ($rate->load(['Rate' => $params]) && $rate->validate()) 
                {
                    if($user->user_type == 0){
                        $rate->user_id = $check->agent_id;
                    }else{                        
                        $rate->user_id = $check->customer_id;
                    }
                    
                    if(!$rate->save()){
                        var_dump($rate->errors);
                    }

                    $request = RateResource::findOne($rate->id);
                    
                    // Calculate the average rating
                    $averageRating = Rate::find()
                        ->where(['user_id' => ($user->user_type == 0) ? $check->agent_id : $check->customer_id ])
                        ->average('user_rating');
                    if ($user->user_type ==UserResource::USER_TYPE_CUSTOMER){

                        $shop=Shop::find()->where(['id'=>$check->shop->id])->one();
                        $shop->rate= ($shop->rate+(double)$rate->user_rating)/2.0;
                        $shop->total_rates+=1;
                        $shop->save();

                    }

                    // Update the user's rate average in the user table
                    $user = User::findOne(($user->user_type == 0) ? $check->agent_id : $check->customer_id);
                    $user->rate_average = $averageRating;
                    $user->save();

                    NotificationHelper::instance()->Rate($rate->id);

                    return ResponseHelper::sendSuccessResponse($request);
                }else{
                    return ResponseHelper::sendFailedResponse(['MESSAGE'=>$rate->errors],400);
                }
            }
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'You can\'t rate the same request two times'], 400);

        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'You Can Not Make This Request.'], 400);
        }
    }

    /**
     * Displays a rating record by Request Id.
     */
    public function actionRequestRate()
    {
        $params = \Yii::$app->request->get();

        $user = UserResource::findOne(\Yii::$app->user->getId());                           
        
        $rate = RequestRateResource::find()
            ->where(['request_id' => $params['id']])->all();

        if ($rate)
            return ResponseHelper::sendSuccessResponse($rate);
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('frontend', 'Invalid Data')], 400);
    }
    
}

