<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use api\resources\FaqResource;
use api\resources\ShopServiceResource;
use common\models\Shop;
use common\models\User;
use api\resources\ShopsResource;
use yii\data\ActiveDataProvider;

class ShopsController extends MyActiveController
{
    public $defaultPageSize= 12; // 20
    public $pageSize= 12;  // 50
    public $pageSizeLimit= [1,200];

    public $modelClass = ShopsResource::class;
    const TOP_RATED=1;
    public function beforeAction($action)
    {
        if(isset($_REQUEST['lang']) && $_REQUEST['lang']== 'ar'){
            \Yii::$app->language= 'ar';
        }
        return parent::beforeAction($action);
    }
    
    public function actionIndex()
    {
        $params = \Yii::$app->request->get();

        $user = User::findOne(\Yii::$app->user->getId());

        $query = ShopsResource::find()->orderBy(['id'=>SORT_DESC]);
        $query->where(['status' => Shop::STATUS_ACTIVE ]);
        if (isset($params['category_id']))
            $query->andWhere(['category_id' => $params['category_id'] ]);

        if (isset($params['top_rated'])&& $params['top_rated']===self::TOP_RATED )
            $query->addOrderBy(['top_shop'=>SORT_DESC]);

        if (isset($params['lat'])&& isset($params['long'])){
//            $query->addOrderBy(['top_shop'=>SORT_DESC]);

        }
        if (isset($params['type_id'])){
            $query->andWhere(['gender'=>$params['type_id']]);
        }else{
            $query->andWhere(['gender'=> [$user->userProfile->gender, Shop::GENDER_ALL] ]);
        }

        if (isset($params['service_id'])){
            $shopIds = ShopServiceResource::find()->select('shop_id')
                ->distinct()->where(['service_id' => $params['service_id']])->column();

            $query->andWhere(['id'=>$shopIds]);

        }
        if (isset($params['name'])){
            $query->andFilterWhere(['like', 'title', $params['name']]);

        }
        if (isset($params['city_id'])){
            $query->andWhere(['city'=>$params['city_id']]);

        }
        if (isset($params['rate_value'])){
//            $query->andWhere(['rate'=>$params['rate_value']]);

        }

        $activeData = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'defaultPageSize' => $this->defaultPageSize , // to set default count items on one page
                'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
            ],
        ]);

        return $activeData;
    }
    public function actionView($id)
    {

        $user = ShopsResource::findOne($id);
        return ResponseHelper::sendSuccessResponse($user);
    }


}