<?php
namespace api\controllers;

use api\helpers\ResponseHelper;
use api\resources\PageResource;
use api\resources\SettingsResource;
use backend\models\Gallery;
use backend\models\Settings;
use Yii;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\helpers\Url;

class SiteController extends Controller
{

    public function actionIndex()
    {
        return 'Welcome...';
    }


    public function beforeAction($action)
    {
        if(isset($_REQUEST['lang']) && $_REQUEST['lang']== 'ar'){
            Yii::$app->language= 'ar';
        }
        return parent::beforeAction($action);
    }


    public function actionTerms()
    {
        \Yii::$app->response->format = \yii\web\Response::FORMAT_JSON;

      //  $page = PageResource::find()->where(['id'=>3])->one();
        $page= "Terms and Conditions" ;
        return ResponseHelper::sendSuccessResponse($page);
    }



    public function actionError()
    {
        if (($exception = Yii::$app->getErrorHandler()->exception) === null) {
            $exception = new NotFoundHttpException(Yii::t('yii', 'Page not found.'));
        }

        if ($exception instanceof \HttpException) {
            Yii::$app->response->setStatusCode($exception->getCode());
        } else {
            Yii::$app->response->setStatusCode(500);
        }

        return $this->asJson(['error' => $exception->getMessage(), 'code' => $exception->getCode()]);
    }
}