<?php

namespace api\controllers;
use api\helpers\ResponseHelper;
use api\resources\UserResource;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use common\models\User;
use common\models\base\TechnicalSupport;
use api\resources\TechnicalSupportResource;
use yii\db\Expression;
use backend\models\Settings;


class TechnicalSupportController extends MyActiveController
{
    public $defaultPageSize= 12; // 20
    public $pageSize= 12;  // 50
    public $pageSizeLimit= [1,200];

    public $modelClass = TechnicalSupportResource::class;

    public function beforeAction($action)
    {
        if(isset($_REQUEST['lang']) && $_REQUEST['lang']== 'ar'){
            \Yii::$app->language= 'ar';
        }
        return parent::beforeAction($action);
    }

    public function actionCreate()
    {
        $params = \Yii::$app->request->post();
        
        $model = new TechnicalSupport();

        if($model->load(['TechnicalSupport' => $params]) && $model->validate())
        {
            $user = User::findOne(\Yii::$app->user->getId());
            
            $model->user_id = $user->id;
            $model->status = TechnicalSupport::STATUS_NEW;
            $model->user_type = $user->user_type;

            if( !$model->save()){
                var_dump($model->errors);
            }

            $request = TechnicalSupportResource::findOne($model->id);
            $request->notifySupportTicket();

            return ResponseHelper::sendSuccessResponse($request);
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>$model->errors],400);
        }
    }

}