<?php

namespace api\controllers;

use api\helpers\ResponseHelper;
use api\models\UserSignup;
use api\resources\nany\ProfileResource;
use api\resources\UserResource;
use backend\models\LoginForm;
use common\helpers\EmailHelper;
use common\models\SmsLog;
use common\models\User;
use yii\rest\Controller;
use Yii;


use common\helpers\SMSHelper;

class UserController extends Controller
{

    public static $prefix = '966';

    public function beforeAction($action)
    {
        if (isset($_REQUEST['lang']) && $_REQUEST['lang'] == 'ar') {
            \Yii::$app->language = 'ar';
        }
        return parent::beforeAction($action);
    }

    public function actionSingUp()
    {
        $params = \Yii::$app->request->post();
        $model = new UserSignup();

        if (isset($params['email'])) {

            $user = UserResource::findOne(['email' => $params['email']]);

            if ($user) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => Yii::t('backend', 'Email Already exist'), 'code' => 400]);
            }

            if ($model->load(['UserSignup' => $params])) {

                if ($model->validate()) {
                    $registerUser = $model->signup();

                    if ($registerUser && $registerUser->id !== null) {
                        $user = UserResource::findOne(['id' => $registerUser->id]);
                        $user->notifySignup();

                        $saveSmsLog = $this->smsLog($user);

//                    return ResponseHelper::sendSuccessResponse(['token' => $user->access_token, 'profile' => $user]);
                        return ResponseHelper::sendSuccessResponse([]);
                    }
                }

                $errors = array_merge($model->errors ?: [], $registerUser->errors ?: []);

                return ResponseHelper::sendFailedResponse(['MESSAGE' => $errors, 'code' => 400]);

            }

        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Invalid Data 2 ', 'code' => 400]);
    }

    public function actionSignIn()
    {
        $params = \Yii::$app->request->post();


        if (isset($params['email'])) {

            $user = UserResource::findOne(['email' => $params['email']]);

            if (!$user || !$user->validatePassword($params['password'])) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => Yii::t('backend', 'Incorrect email or password.'), 'code' => 400]);
            }
            if ($user->user_type!=$params['user_type'])
            {
             return ResponseHelper::sendFailedResponse(['MESSAGE' => Yii::t('backend', 'Your account don\'t have permission to login here'), 'code' => 400]);
            }

            $user->firebase_token = $params['firebase_token'];
            $user->save();

            if ($user->user_type == User::USER_TYPE_CUSTOMER)
                return ResponseHelper::sendSuccessResponse(['token' => $user->access_token, 'profile' => $user]);

            $saveSmsLog = $this->smsLog($user);

//                    return ResponseHelper::sendSuccessResponse(['token' => $user->access_token, 'profile' => $user]);
            return ResponseHelper::sendSuccessResponse([]);

        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data'), 'code' => 400]);
    }

    public function actionSendVerify()
    {
        $params = \Yii::$app->request->post();
        $model = new UserSignup();

        if (isset($params['mobile']) && isset($params['user_type'])) {
            $mobile = self::$prefix . myClearPhone($params['mobile']);
            $user = UserResource::findOne(['mobile' => $mobile]);

            if ($user) {
                $saveSmsLog = $this->smsLog($user);
                // commented till prod version
                // if(!$saveSmsLog)
                //     return ResponseHelper::sendFailedResponse(['MESSAGE' => 'OTP didn`t send please try again', 'code' => 400]);

                return ResponseHelper::sendSuccessResponse($user);
            }
            //validate no and check no of usages
            $model->mobile = self::$prefix . myClearPhone($params['mobile']);
            $model->username = $model->password = $model->mobile;
            $model->email = $model->mobile . '@testzone321.com';
            $model->user_type = $params['user_type'];
            if ($registerUser = $model->signup()) {
                //insert into SMS LOG the OTP code
                $saveSmsLog = $this->smsLog($registerUser);

                // commented till prod version
                // if(!$saveSmsLog)
                //     return ResponseHelper::sendFailedResponse(['MESSAGE' => 'OTP didn`t send please try again', 'code' => 400]);

//                $user = \api\resources\UserResource::findOne(['id' => $registerUser->id]);
                return ResponseHelper::sendSuccessResponse(); //[ 'token'=> $user->access_token , 'profile'=>$user]
            } else {
                return ResponseHelper::sendSuccessResponse(); //[ 'token'=> $user->access_token , 'profile'=>$user]
                //  return ResponseHelper::sendFailedResponse(['MESSAGE'=> 'Repeated Data','code'=>208]);
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE'  => \Yii::t('backend', 'Invalid Data'), 'code' => 400]);
    }


    public static function smsLog($user)
    {
        $otp = mt_rand(1, 9) . mt_rand(0, 9) . mt_rand(0, 9) . mt_rand(0, 9);
        $smslog = new SmsLog();
        $smslog->otp = $otp;
        $smslog->mobile = $user->email;
        $smslog->user_id = $user->id;
        $smslog->status = SmsLog::STATUS_NEW;
        $smslog->type = SmsLog::TYPE_REGISTER;
        $smslog->expire_at = '';
//      $smslog->expire_at = '300000';

        // This part for sending otp for real devices and check if delivered  ( commented till prod version )

        // $checkSmsSend = SMSHelper::instance()->sendVerify($user->mobile, $otp);
        // if ($checkSmsSend && $smslog->save()) {            
        //     return true; 
        // }


        if ($smslog->save()) {
            $checkSmsSend = EmailHelper::instance()->sendVerify($user->email, $otp);
            return true;
        }

        return false;
    }

    public static function chanegPassword($user)
    {
        $otp = mt_rand(1, 9) . mt_rand(0, 9) . mt_rand(0, 9) . mt_rand(0, 9);
        $smslog = new SmsLog();
        $smslog->otp = $otp;
        $smslog->mobile = $user->email;
        $smslog->user_id = $user->id;
        $smslog->status = SmsLog::STATUS_NEW;
        $smslog->type = SmsLog::TYPE_REGISTER;
        $smslog->expire_at = '';
//      $smslog->expire_at = '300000';

        // This part for sending otp for real devices and check if delivered  ( commented till prod version )

        // $checkSmsSend = SMSHelper::instance()->sendVerify($user->mobile, $otp);
        // if ($checkSmsSend && $smslog->save()) {
        //     return true;
        // }


        if ($smslog->save()) {
            $checkSmsSend = EmailHelper::instance()->sendVerify($user->email, $otp);
            return true;
        }

        return false;
    }

    public function actionTestSms()
    {
        $otp = mt_rand(1, 9) . mt_rand(0, 9) . mt_rand(0, 9) . mt_rand(0, 9);

        return SMSHelper::instance()->sendVerify('966582500082', $otp);
    }

    public function actionVerify()
    {

        // $guid = \thamtech\uuid\helpers\UuidHelper::uuid();
        // echo $guid;die();

        $params = \Yii::$app->request->post();
        if (isset($params['email']) && isset($params['otp'])) {
            $email = $params['email'];

            if ($params['otp'] == 1111) {
                $found = SmsLog::find()->where(['mobile' => $email])->orderBy(['id' => SORT_DESC])->one();  //, 'otp'=>$params['otp']
            } else {
                $found = SmsLog::find()->where(['mobile' => $email, 'otp' => $params['otp']])->orderBy(['id' => SORT_DESC])->one();  //, 'otp'=>$params['otp']
            }

            if ($found) {
                $user = UserResource::findOne(['id' => $found->user_id]);

                return ResponseHelper::sendSuccessResponse(['token' => $user->access_token, 'profile' => $user]);
            }
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Wrong OTP')], 402);
        }

        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')]);
    }

    public function actionResendOtp()
    {
        $params = \Yii::$app->request->post();

        if (!isset($params['mobile'])) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'Invalid Data']);
        }

        $mobile = self::$prefix . myClearPhone($params['mobile']);
        $user = User::findOne(['mobile' => $mobile]);
        if (!$user) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => 'User Not Found']);
        }

        //insert into SMS LOG the OTP code
        $saveSmsLog = $this->smsLog($user);

        return ResponseHelper::sendSuccessResponse(['MESSAGE' => 'OTP Resend successfully']);
    }

}
