<?php

namespace api\controllers;
use api\helpers\ResponseHelper;
use api\resources\BookingResource;
use api\resources\UserResource;
use api\resources\WalletTempResource;
use common\models\base\Booking;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use api\resources\WalletResource;
use api\resources\BankResource;
use api\resources\WithdrawalResource;
use api\resources\BankAccountResource;
use common\models\base\Payment;
use common\models\base\CustomerRequest;
use common\models\base\Withdrawal;
use common\models\base\BankAccount;
use common\models\base\Bank;
use common\models\User;
use yii\db\Expression;
use backend\models\Settings;


class WalletController extends MyActiveController
{
    public $defaultPageSize= 12; // 20
    public $pageSize= 12;  // 50
    public $pageSizeLimit= [1,200];

    public $modelClass = WalletResource::class;

    public function beforeAction($action)
    {
        if(isset($_REQUEST['lang']) && $_REQUEST['lang']== 'ar'){
            \Yii::$app->language= 'ar';
        }
        return parent::beforeAction($action);
    }

        public function actionIndex()
    {
        $params = \Yii::$app->request->get();

        $user = UserResource::findOne(\Yii::$app->user->getId());

        $query = $this->modelClass::find()->orderBy(['payment.id' => SORT_DESC]);

        $query->where(['payment.user_id' => $user->id, 'withdrawal'=> Payment::NOT_WITHDRAWED]);

        $query->andWhere(['booking.status' =>
        [
            Booking::STATUS_ENDED,
            Booking::STATUS_PAID,
            Booking::STATUS_CANCELED,

        ]]);
        $query->orWhere(['extended_booking.status' =>
        [
            Booking::STATUS_ENDED,
            Booking::STATUS_PAID,
            Booking::STATUS_CANCELED,

        ]]);
        
        $query->andWhere(['!=', 'payment.hide', 1]);
        $query->andWhere(['!=', 'payment.refund_type', Payment::FULL_REFUND]);

        $query->select('payment.*,booking.status');
        $query->select('payment.*,extended_booking.status');
        $query->leftJoin('booking', 'booking.id = payment.booking_id');
        $query->leftJoin('extended_booking', 'extended_booking.id = payment.booking_id');
        if (isset($params['created_at'])) {
            $startDate =$params['created_at'] . ' 00:00:00';
            $endDate =$params['created_at'] . ' 23:59:59';
            $query->andWhere(['between', 'payment.created_at', strtotime( $startDate),  strtotime($endDate)]);

        }
        $totalAmountSum = 0;
        foreach ($query->all() as $walletItem) {
            $totalAmountSum += $walletItem->paid_amount;
            // refund out of the sum

        }
        $activeData = new ActiveDataProvider([
                    'query' => $query,
                    'pagination' => [
                        'defaultPageSize' => $this->defaultPageSize , // to set default count items on one page
                        'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                        'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
                    ],
                ]);
        return ResponseHelper::sendSuccessResponse(['total_services_paid'=>$totalAmountSum,'total_refund'=>0,'payment_list'=>$activeData]);

//        return $activeData;
    }

    public function actionBanks()
    {
        $banks = BankResource::find()->all();

        return ResponseHelper::sendSuccessResponse($banks);
    }

    public function actionAddAccount()
    {
        $params = \Yii::$app->request->post();        
        $model = new BankAccount();

        if($model->load(['BankAccount'=>$params]) && $model->validate())
        {
            $model->nany_id = \Yii::$app->user->getId();

            if( !$model->save()){
                var_dump($model->errors);
            }

            $request = BankAccountResource::findOne($model->id);

            return ResponseHelper::sendSuccessResponse($request);
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>$model->errors],400);
        }
    }

    public function actionBankAccount()
    {
        $bank_accounts = BankAccountResource::find()->where(['nany_id' => \Yii::$app->user->getId()])->all();

        return ResponseHelper::sendSuccessResponse($bank_accounts);
    }

    public function actionDeleteBankAccount($id)
    {
        $user = UserResource::findOne(\Yii::$app->user->getId());

        $account = BankAccount::find()->where(['id' => $id , 'nany_id' => $user->id ])->one();

        if($account){
            if($account->delete()){
                
                return ResponseHelper::sendSuccessResponse(['MESSAGE'=> \Yii::t('frontend', 'Bank account has been deleted successfully')],200);
            }else{
                return ResponseHelper::sendFailedResponse(['MESSAGE'=> \Yii::t('frontend', 'There is an error occured please check this again"')],400);
            }
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=> \Yii::t('frontend', 'The bank account data not found')],400);
        }
    }

    public function actionWithdraw()
    {
        $params = \Yii::$app->request->post();
        
        $model = new Withdrawal();

        if($model->load(['Withdrawal' => $params]) && $model->validate())
        {
            $user = User::findOne(\Yii::$app->user->getId());

// start of old calculation
            // $settings = Settings::findOne(1);
            // $model->nany_id = $user->id;
            // $model->total = $user->wallet;
            // if($settings->service_fee_type == Settings::SERVICE_FEE_TYPE_FIXED){
            //     $fees = $settings->service_fees;
            // }else{
            //     $fees = $user->wallet * $settings->service_fees / 100;                                 
            // }
            // $model->fees = $fees;            
            // $model->final_total = $user->wallet - $fees;
            // End of old calculation

            // New edits 
            $model->nany_id = $user->id;
            $model->total = $user->wallet;        
            $model->final_total = $user->wallet;

            $model->status = Withdrawal::STATUS_PENDING;

            if( !$model->save()){
                var_dump($model->errors);
            }   

            $paymentLogs = Payment::find()
            ->where([
                    'payment.nany_id' => $user->id, 
                    'payment.withdrawal' => Payment::NOT_WITHDRAWED,
                    'customer_requests.request_tracking_status' => [CustomerRequest::REQUEST_TRACKING_STATUS_ENDED, CustomerRequest::REQUEST_TRACKING_STATUS_CUSTOMER_CANCEL, CustomerRequest::REQUEST_TRACKING_STATUS_NANNY_CANCEL , CustomerRequest::REQUEST_TRACKING_STATUS_ADMIN_CANCEL]
                ])
            ->select(['payment.*','customer_requests.request_tracking_status'])
            ->leftJoin('customer_requests', 'customer_requests.id = payment.request_id')                      
            ->all();

            foreach($paymentLogs as $log){
                $log->withdrawal = Payment::WITHDRAWED;
                $log->save();
            }

            // Payment::updateAll(['withdrawal' => Payment::WITHDRAWED], ['nany_id' => $user->id, 'withdrawal'=> Payment::NOT_WITHDRAWED]);

            $user->wallet = 0;
            $user->wallet_last_update = strtotime(date("Y-m-d H:i"));
            $user->save();

            return ResponseHelper::sendSuccessResponse(['MESSAGE' => \Yii::t('frontend', 'Withdrawal proccess has been successeded')]);
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>$model->errors],400);
        }
    }

    public function actionWithdrawals()
    {        
        $user = UserResource::findOne(\Yii::$app->user->getId());

        $query = WithdrawalResource::find()->orderBy(['id' => SORT_DESC]);

        $query->where(['nany_id' => $user->id]);
        
        $activeData = new ActiveDataProvider([
                    'query' => $query,
                    'pagination' => [
                        'defaultPageSize' => $this->defaultPageSize , // to set default count items on one page
                        'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                        'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
                    ],
                ]);
        return $activeData;       
    }

}