<?php
/**
 * Created by PhpStorm.
 * User: engamer
 * Date: 04/02/19
 * Time: 10:03 ص
 */

namespace api\controllers\agent;

use api\helpers\ResponseHelper;
use api\resources\ShopServiceResource;
use yii\data\ActiveDataProvider;
use yii\filters\auth\CompositeAuth;
use yii\filters\auth\HttpBearerAuth;
use yii\rest\ActiveController;

use api\resources\agent\ProfileResource;
use common\models\User;

class AgentsController extends ActiveController
{
    public $modelClass = ProfileResource::class;

    public $defaultPageSize= 50; // 20
    public $pageSize= 50;  // 50
    public $pageSizeLimit= [1,200];
    const TOP_RATED=1;
    public function actions(){
        $actions = parent::actions();
        unset($actions['index']);
        unset($actions['view']);
        unset($actions['create']);
        unset($actions['update']);
        unset($actions['delete']);
        return $actions;
    }

    public function  behaviors()
    {
        $behaviors = parent::behaviors();
        // remove authentication filter if there is one
        unset($behaviors['authenticator']);

        // add CORS filter before authentication
        $behaviors['corsFilter'] = [
            'class' => \yii\filters\Cors::className(),
        ];

        // Put in a bearer auth authentication filter
        $behaviors['authenticator'] = [
            'class' => CompositeAuth::class,
            'authMethods' => [
                HttpBearerAuth::class,
            ]
        ];
        // avoid authentication on CORS-pre-flight requests (HTTP OPTIONS method)
        $behaviors['authenticator']['except'] = ['options'];
        return $behaviors;
    }



    public function actionIndex()
    {
        $params= \Yii::$app->request->get();

        $query = ProfileResource::find();
        $query->where(['user.user_type' => User::USER_TYPE_AGENT,'user.status'=>User::STATUS_ACTIVE]);

        if (isset($params['shop_id']))
            $query->andWhere(['user.shop_id' => $params['shop_id'] ]);

        if (isset($params['top_rated'])&& $params['top_rated']===self::TOP_RATED )
            $query->addOrderBy(['user.rate_average'=>SORT_DESC]);


        $activeData = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'defaultPageSize' => $this->defaultPageSize , // to set default count items on one page
                'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize

            ],
        ]);
        return $activeData;
    }

    public function actionView($id)
    {
        $agent = ProfileResource::findOne($id);
        return ResponseHelper::sendSuccessResponse($agent);
    }
    public function actionAgentServices()
    {
        $params= \Yii::$app->request->get();

        $services = ShopServiceResource::find()
            ->select(['shop_service.*'])
            ->distinct()
            ->joinWith('userShopServices')
            ->andWhere(['user_shop_service.user_id' => $params['agent_id']])
            ->all();

        if ($services) {
            return ResponseHelper::sendSuccessResponse($services);
        }
        else {
            return ResponseHelper::sendSuccessResponse([]);
        }


    }

    public $serializer = [
        'class' => 'yii\rest\Serializer',
        'collectionEnvelope' => 'data',
    ];
}

