<?php
/**
 * Created by PhpStorm.
 * User: engamer
 * Date: 04/02/19
 * Time: 10:03 ص
 */

namespace api\controllers\agent;

use api\controllers\UserController;
use api\helpers\ImageHelper;
use api\helpers\ResponseHelper;
use api\models\BookingForm;
use api\models\ExtendBookingForm;
use api\resources\ShopServiceResource;
use api\resources\ExtendedBookingResource;
use api\resources\UserResource;
use common\models\AgentSlots;
use common\models\base\Booking;
use common\models\UserProfile;
use common\models\UserShopService;
use DateTime;
use Yii;
use yii\data\ActiveDataProvider;
use yii\filters\auth\CompositeAuth;
use yii\filters\auth\HttpBearerAuth;
use yii\rest\ActiveController;

use common\helpers\NotificationHelper;

use api\resources\agent\BookingResource;
use common\models\User;

use common\helpers\BookingHelper;

class BookingsController extends ActiveController
{
    public $modelClass = BookingResource::class;

    public $defaultPageSize = 50; // 20
    public $pageSize = 50;  // 50
    public $pageSizeLimit = [1, 200];

    public function actions()
    {
        $actions = parent::actions();
        unset($actions['index']);
        unset($actions['view']);
        unset($actions['create']);
        unset($actions['update']);
        unset($actions['delete']);
        return $actions;
    }

    public function behaviors()
    {
        $behaviors = parent::behaviors();
        // remove authentication filter if there is one
        unset($behaviors['authenticator']);

        // add CORS filter before authentication
        $behaviors['corsFilter'] = [
            'class' => \yii\filters\Cors::className(),
        ];

        // Put in a bearer auth authentication filter
        $behaviors['authenticator'] = [
            'class' => CompositeAuth::class,
            'authMethods' => [
                HttpBearerAuth::class,
            ]
        ];
        // avoid authentication on CORS-pre-flight requests (HTTP OPTIONS method)
        $behaviors['authenticator']['except'] = ['options'];
        return $behaviors;
    }

    public function actionIndex()
    {
        $params = \Yii::$app->request->get();

        $user = User::findOne(\Yii::$app->user->getId());

        $query = $this->modelClass::find();
        $query->where(['agent_id' => $user->id])->orderBy(['id'=>SORT_DESC]);
            // ->andWhere(['>', 'status', Booking::STATUS_IN_PROGRESS]);

        if (isset($params['booking_date'])){
            $query->andWhere(['booking_date' => $params['booking_date']]);

        }
        if (isset($params['old'])) {
            if ($params['old'] == 0) {
                // Include old and new items
                $query->andWhere(['>=', 'booking_date', date('Y-m-d')])
                    ->andWhere(['not in', 'status',[Booking::STATUS_CANCELED,Booking::STATUS_ENDED,Booking::STATUS_IN_SESSION,Booking::STATUS_CANCELED_BY_SHOP]]);
            } elseif ($params['old'] == 1) {
                // Include only old items when status = 0
                $query->andWhere(['or', ['<=', 'booking_date', date('Y-m-d')],['status' => [Booking::STATUS_CANCELED,Booking::STATUS_ENDED,Booking::STATUS_IN_SESSION,Booking::STATUS_CANCELED_BY_SHOP]]]);
            }
        }

        $activeData = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'defaultPageSize' => $this->defaultPageSize, // to set default count items on one page
                'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
            ],
        ]);
        return $activeData;
    }

    public function actionView($id)
    {

        $booking = BookingResource::findOne($id);
        if($booking){
            return ResponseHelper::sendSuccessResponse($booking);
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>\Yii::t('backend', 'Not Found')],404);
        }
    }

    public function actionAgentServices()
    {
        $params = \Yii::$app->request->post();

        if (isset($params['services_ids'])) {

            $services = ShopServiceResource::find()
                ->select(['shop_service.*'])
                ->distinct()
                ->where(['not in', 'shop_service.id', $params['services_ids']])
                ->joinWith('userShopServices')
                ->andWhere(['user_shop_service.user_id' => \Yii::$app->user->getId()])
                ->all();

            if ($services) {
                return ResponseHelper::sendSuccessResponse($services);
            } else {
                return ResponseHelper::sendSuccessResponse([]);
            }
        }

        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Missing parameters')], 404);
    }


    public function actionBook()
    {
        $params = \Yii::$app->request->post();

        if (isset($params['email'],
            $params['name'],
            $params['mobile'],
            $params['schedule_date'],
            $params['from_hour'],
            $params['to_hour'])) {

            $booking = new BookingResource();
            $booking->mobile = UserController::$prefix . myClearPhone($params['mobile']);
            $booking->name = $params['name'];
            $booking->email = $params['email'];

//                $booking->customer_id = $this->user($params['email'],$params['name'],$params['mobile'],);
            $booking->agent_id = \Yii::$app->user->getId();
            $booking->shop_id = \Yii::$app->user->identity->shop_id;
            $booking->booking_date = $params['schedule_date'];
            $booking->from_hour = $params['from_hour'];
            $booking->to_hour = $params['to_hour'];
            $booking->status = Booking::STATUS_PAID;

//            Preparing agent slot


            if ($booking->save()) {
                $agentSlots = new AgentSlots();
                $agentSlots->agent_id = \Yii::$app->user->getId();
                $agentSlots->booking_id = $booking->id;
                $agentSlots->booking_date = $booking->booking_date;
                $agentSlots->from_hour = $booking->from_hour;
                $agentSlots->to_hour = $booking->to_hour;
                $agentSlots->save();
                return ResponseHelper::sendSuccessResponse($booking);
            }
        }
        return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
    }

    public function user($email, $name, $mobile)
    {
        $user = UserResource::findOne(['email' => $email]);
        if (!$user) {
            $user = new User();
            $user->mobile = UserController::$prefix . myClearPhone($mobile);
            $user->full_name = $name;

            $user->username = $user->email = $email;
            $user->setPassword("123456789");
            $user->generateAuthKey();
            $user->status = User::STATUS_ACTIVE;

            $user->user_type = User::USER_TYPE_CUSTOMER;
            if ($user->save()) {
                $auth = Yii::$app->authManager;
                $role = $auth->getRole(User::ROLE_USER);
                $auth->assign($role, $user->id);
                $profile = new UserProfile();
                $profile->locale = 'en';
                $user->link('userProfile', $profile);
            }

        }
        return $user->id;

    }

    public function actionUpdateStatus($id)
    {
        $params = \Yii::$app->request->post();

        // Qotb Tomorrow

        // if (BookingHelper::instance()->checkAgentAvailability())
        //     return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('frontend', 'Sorry, you cannot approve before ending the current session.')], 400);

        $user = User::findOne(\Yii::$app->user->getId());
        $booking = Booking::find()->where(['id' => $id, 'agent_id' => $user->id])->one();        

        if ($booking) 
        {
            $booking->status = $params['status'];
            $booking->save();

            NotificationHelper::instance()->agentUpdateBookingStatus($booking);

            return ResponseHelper::sendSuccessResponse(['MESSAGE' => \Yii::t('frontend', 'Your request has been updated successffully')], 200);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('frontend', 'The request is not found')], 400);
        }
    }


    public function actionExtendBooking()
    {
//      without promo code
        $params = \Yii::$app->request->post();
        $model = new ExtendBookingForm();

        $model->booking_id = $params['booking_id'];

        $booking = Booking::find()->where(['id' => $params['booking_id']])->one();
        if (!$booking) {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Booking Id')], 404);
        }

        $model->from_hour = $booking->to_hour;

        $model->checkServicesTime($booking,$params['services_ids']);

        $agentSlots = AgentSlots::find()->where(['agent_id'=>\Yii::$app->user->getId(),
            'booking_date'=>$booking->booking_date,
            'from_hour'=> $booking->from_hour,
            'to_hour'=>$booking->to_hour])->one();

        $agentSlotsNext = AgentSlots::find()
            ->where(['agent_id' => \Yii::$app->user->getId(),
                'booking_date'=>$booking->booking_date,])
            ->andWhere(['>', 'from_hour', $booking->to_hour])
            ->orderBy(['from_hour' => SORT_ASC])
            ->one();


        if ($agentSlotsNext !== null) {
            $fromHourNext = new DateTime($agentSlotsNext->from_hour);
            $toHour = new DateTime($agentSlots->to_hour);

            $timeBetweenSlots = (int) $fromHourNext->diff($toHour)->format('%i');

            if ( $model->services_time >= $timeBetweenSlots) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'This slot is busy')], 404);
            }
        }

        if ($model->load(['ExtendBookingForm' => $params]) && $model->validate()) {
            if (!$model->save()) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Shop Data')], 404);
            }
            $booking = ExtendedBookingResource::findOne($model->extended_booking_id);

            NotificationHelper::instance()->agentExtendBooking($booking);

            return ResponseHelper::sendSuccessResponse($booking);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => \Yii::t('backend', 'Invalid Data')], 404);
        }
    }


    public $serializer = [
        'class' => 'yii\rest\Serializer',
        'collectionEnvelope' => 'data',
    ];
}

