<?php

namespace api\controllers\agent;

use api\helpers\ResponseHelper;
use api\resources\AgentWithdrawalResource;
use api\resources\UserResource;
use common\models\base\AgentWithdrawal;
use DateTime;
use DateTimeZone;
use yii\base\Model;
use yii\data\ActiveDataProvider;
use api\resources\WalletResource;
use api\resources\BankResource;
use api\resources\WithdrawalResource;
use api\resources\BankAccountResource;
use common\models\base\Payment;
use common\models\base\CustomerRequest;
use common\models\base\Withdrawal;
use common\models\base\BankAccount;
use common\models\base\Bank;
use common\models\User;
use yii\db\Expression;
use backend\models\Settings;
use api\resources\WalletTempResource;
use common\models\base\Booking;

use api\controllers\MyActiveController;


class WalletController extends MyActiveController
{
    public $defaultPageSize = 12; // 20
    public $pageSize = 12;  // 50
    public $pageSizeLimit = [1, 200];

    public $modelClass = WalletResource::class;

    public function beforeAction($action)
    {
        if (isset($_REQUEST['lang']) && $_REQUEST['lang'] == 'ar') {
            \Yii::$app->language = 'ar';
        }
        return parent::beforeAction($action);
    }

    public function actionIndex()
    {
        $params = \Yii::$app->request->get();

        $user = UserResource::findOne(\Yii::$app->user->getId());

        $query = $this->modelClass::find()->orderBy(['payment.id' => SORT_DESC]);

        $query->where(['payment.agent_id' => $user->id, 'withdrawal' => Payment::NOT_WITHDRAWED]);

        $query->andWhere(['booking.status' =>
            [
                Booking::STATUS_ENDED,
                Booking::STATUS_PAID,
                Booking::STATUS_CANCELED,

            ]]);

        $query->orWhere(['extended_booking.status' =>
            [
                Booking::STATUS_ENDED,
                Booking::STATUS_PAID,
                Booking::STATUS_CANCELED,

            ]]);

        $query->andWhere(['!=', 'payment.hide', 1]);
        $query->andWhere(['!=', 'payment.refund_type', Payment::FULL_REFUND]);

        $query->select('payment.*,booking.status');
        $query->select('payment.*,extended_booking.status');

        $query->leftJoin('booking', 'booking.id = payment.booking_id');
        $query->leftJoin('extended_booking', 'extended_booking.id = payment.booking_id');

        if (isset($params['created_at'])) {
                $startDate =$params['created_at'] . ' 00:00:00';
                $endDate =$params['created_at'] . ' 23:59:59';

                $query->andWhere(['between', 'payment.created_at', strtotime( $startDate),  strtotime($endDate)]);


        }
        $transactions = $query->all();

        return ResponseHelper::sendSuccessResponse([
            'no_of_services' => $user->services_count,
            'no_of_tippings' => $user->tippings_count,
            'total_services_amount' => $user->total_services_amount,
            'total_tippings_amount' => $user->total_tippings_amount,
            'transactions' => $transactions,
        ]);
    }

    public function actionWithdraw()
    {
        $user = User::findOne(\Yii::$app->user->getId());

        $params = \Yii::$app->request->post();

        $model = AgentWithdrawal::find()->where(['id' => $params['withdraw_id'], 'agent_id' => $user->id])->one();

        if ($model) {
            $model->status = $params['status'];

            if (!$model->save()) {
                return ResponseHelper::sendFailedResponse(['MESSAGE' => $model->errors], 400);
            }
            $agents = User::find()->where(['shop_id' => $user->shop_id, 'user_type' => User::USER_TYPE_AGENT])->all();


            if ($model->status == Withdrawal::STATUS_READY_TO_WITHDRAWAL) {

                $withdrawal = new \common\models\Withdrawal();
                $withdrawal->shop_id =$user->shop_id;
                $withdrawal->total=0;
                foreach ($agents as $agent) {
                    $withdrawal->total += $agent->total_services_amount;
                }
                $withdrawal->withdrawal_type = User::WITHDRAWAL_TYPE_SERVICES;
                $withdrawal->status = Withdrawal::STATUS_READY_TO_WITHDRAWAL;// ready to withdrawal
                $withdrawal->save(false);




                $paymentLogs = Payment::find()
                    ->where([
                        'payment.agent_id' => $user->id,
                        'payment.withdrawal' => null,
                        'booking.status' => [Booking::STATUS_ENDED,
                            Booking::STATUS_CANCELED]
                    ])->orWhere(['payment.agent_id' => $user->id,
                        'payment.withdrawal' => null, 'extended_booking.status' =>
                            [Booking::STATUS_ENDED,
                                Booking::STATUS_CANCELED]

                    ])
                    ->select(['payment.*', 'booking.status'])
                    ->select('payment.*,extended_booking.status')
                    ->leftJoin('booking', 'booking.id = payment.booking_id')
                    ->leftJoin('extended_booking', 'extended_booking.id = payment.booking_id')
                    ->all();

                foreach ($paymentLogs as $log) {
                    $log->withdrawal = Payment::WITHDRAWED;
                    $log->save();
                }

                $model->withdrawal_type == User::WITHDRAWAL_TYPE_TIPPING ? $user->total_tippings_amount = 0 :
                    $user->total_services_amount = 0;

                $user->wallet_last_update = strtotime(date("Y-m-d H:i"));
                $user->save(false);

            }
            return ResponseHelper::sendSuccessResponse(['MESSAGE' => \Yii::t('frontend', 'Withdrawal proccess has been successeded')]);
        } else {
            return ResponseHelper::sendFailedResponse(['MESSAGE' => $model->errors], 400);
        }
    }

    public function actionWithdrawals()
    {
        $user = UserResource::findOne(\Yii::$app->user->getId());

        $query = AgentWithdrawalResource::find()->orderBy(['id' => SORT_DESC]);

        $query->where(['agent_id' => $user->id]);

        $activeData = new ActiveDataProvider([
            'query' => $query,
            'pagination' => [
                'defaultPageSize' => $this->defaultPageSize, // to set default count items on one page
                'pageSize' => $this->pageSize, //to set count items on one page, if not set will be set from defaultPageSize
                'pageSizeLimit' => $this->pageSizeLimit, //to set range for pageSize
            ],
        ]);
        return $activeData;
    }
}