<?php

namespace api\models;


use api\controllers\UserController;
use api\helpers\ResponseHelper;
use api\resources\PackagesResource;
use api\resources\PackagesServiceResource;
use backend\models\Settings;
use common\models\base\Booking;
use common\models\base\PackagesService;
use common\models\BookingService;
use common\models\PromoCode;
use common\models\ShopService;
use common\models\UserShopService;
use Yii;
use yii\base\Model;

/**
 * Model representing  booking Form.
 */
class BookingForm extends Model
{

    public $services_ids = [];
    public $shop_id;
    public $invoice_id;
    public $package_id;
    public $agent_id;
    public $booking_id;
    public $schedule_date;
    public $from_hour;
    public $to_hour;
    public $valid_code = 0;


    public $promo_code;
    public $promo_code_value = 0;
    public $promo_code_id;
    public $amount;
    public $total_paid;
    public $vat;
    const NOT_VALID = 1;
    const TYPE_AMOUNT = 1;

    /**
     * Returns the validation rules for attributes.
     *
     * @return array
     */
    public function rules()
    {
        return [
            [['services_ids',], 'required'],
            [['services_ids',], 'safe'],
            [['shop_id', 'valid_code', 'booking_id', 'package_id','agent_id', 'promo_code_id'], 'integer'],
            [['amount', 'total_paid', 'promo_code_value', 'vat'], 'number'],
            [['promo_code', 'schedule_date', 'from_hour', 'invoice_id','to_hour'], 'string'],


        ];
    }


    /**
     * Returns the attribute labels.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return [
            'services_ids' => Yii::t('common', 'Services ids'),
            'promo_code' => Yii::t('common', 'Promo code'),
        ];
    }

    public function save()
    {
        if (!$this->validate()) {
            return false;
        }
//        preparing booking data
        $this->preparingWithPromoCode();

        $booking = new Booking();
        $booking->mobile = UserController::$prefix . myClearPhone(\Yii::$app->user->identity->mobile);
        $booking->name = \Yii::$app->user->identity->full_name;
        $booking->email = \Yii::$app->user->identity->email;
        $booking->customer_id = \Yii::$app->user->getId();
        $booking->shop_id = $this->shop_id;
        $booking->discount_value = $this->promo_code_value;
        $booking->promo_code_id = $this->promo_code_id;
        $booking->vat = $this->vat;
        $booking->sub_amount = $this->amount;
        $booking->total_amount = $this->total_paid;
        if ($booking->save(false)) {
            $services = ShopService::findAll($this->services_ids);
            if (!$services){
                return false;
            }
            $this->preparingBookingServices($services, $booking);
            $this->booking_id = $booking->id;
            return true;

        }
        var_dump($booking->errors);
        return false;

    }

    public function preparingBookingServices($services, $booking)
    {

        // Iterate through the services and add them to BookingService.
        foreach ($services as $service) {
            $bookingService = new BookingService();
            $bookingService->service_id = $service->id;
            $bookingService->booking_id = $booking->id;
            $bookingService->save(false);
        }

    }



    public function preparingWithPromoCode()
    {

        $this->services_ids=$this->checkServices();
        $services = ShopService::findAll($this->services_ids);

        if (!$this->allServicesHaveSameShop($services)||!$services) {
            return false;
        }
        //        calculate Vat value

        $this->vat();
        $this->total_paid = $this->amount + $this->vat;
        if ($this->promo_code != null && $this->promo_code != '') {
            $promo_code = PromoCode::find()
                ->where([
                    'code' => $this->promo_code,
                    'status' => PromoCode::STATUS_ACTIVE,
                    'shop_id' => $this->shop_id,
                ])
                ->andWhere(['!=', 'remaining_uses', 0])
                ->andWhere(['>', 'STR_TO_DATE(expiry_date, "%d/%m/%Y")', date('Y-m-d')])
                ->one();
            if ($promo_code) {

                //        calculate discount_value value
                $this->promo_code_id = $promo_code->id;
                $this->discount_value($promo_code->discount_type, $promo_code->discount_value, $this->amount);
                $this->total_paid -= $this->promo_code_value;
                $promo_code->uses+=1;
                $promo_code->save();
            } else {
                $this->valid_code = self::NOT_VALID;
            }
        }
        return true;

    }
    public function preparingPackageWithPromoCode($package)
    {
//        calculate Vat value
        $this->amount=(double)$package->price;

        $this->vat();

        $this->services_ids = PackagesService::find()
            ->select('service_id')
            ->where(['package_id' => $this->package_id])
            ->column();
//
//        $services = ShopService::findAll(['id' => $this->services_ids]);

        $this->shop_id=$package->shop_id;
        $this->total_paid = (double)$this->amount + (double)$this->vat;

        if ($this->promo_code != null && $this->promo_code != '') {
            $promo_code = PromoCode::find()
                ->where([
                    'code' => $this->promo_code,
                    'status' => PromoCode::STATUS_ACTIVE,
                    'shop_id' => $this->shop_id,
                ])
                ->andWhere(['!=', 'remaining_uses', 0])
                ->andWhere(['>', 'STR_TO_DATE(expiry_date, "%d/%m/%Y")', date('Y-m-d')])
                ->one();
            if ($promo_code) {
                //        calculate discount_value value
                $this->promo_code_id = $promo_code->id;
                $this->discount_value($promo_code->discount_type, $promo_code->discount_value, $this->amount);
                $this->total_paid -= $this->promo_code_value;
                $promo_code->uses+=1;
                $promo_code->save();
            } else {
                $this->valid_code = self::NOT_VALID;
            }
        }
        return true;

    }


    public function checkServices()
    {

        $serviceIds = $this->services_ids;
        $serviceIdsLength = count($serviceIds);


        $agents = UserShopService::find()
            ->select('user_id')
            ->groupBy('user_id')
            ->having(['count(distinct service_id)' => count($serviceIds)])
            ->andWhere(['service_id' => $serviceIds])
            ->all();

        if ($agents) {
            return $serviceIds;
        } else {
            while ($serviceIdsLength > 0) {

                $serviceIdsLength--;
                $newServices = $this->getUniqueServices($serviceIds, $serviceIdsLength);
                $allData = $this->processNewServicesList($newServices);

                if (count($allData) == 1) {
                    return $allData[0]['services'];
                }
                if (count($allData) > 1) {
                    $highestCostList = $this->findHighestCostList($allData);

                    return $highestCostList;
                }
            }


        }
        return [];

    }

    public function findHighestCostList($allData)
    {
        $totalCosts = [];

        // Calculate the total cost for each data entry
        foreach ($allData as $data) {
            $totalCost = 0;
            $serviceIds = $data['services'];

            foreach ($serviceIds as $serviceId) {
                $service = ShopService::findOne($serviceId);
                $totalCost += $service->service_amount;
            }

            $totalCosts[] = $totalCost;
        }

        // Find the list with the highest total cost
        $maxCost = max($totalCosts);
        $index = array_search($maxCost, $totalCosts);

        if ($index !== false) {
            $highestCostList = $allData[$index];
            return $highestCostList['services'];
        } else {
            // equaled
            return $allData[0]['services'];
        }
    }

    public function processNewServicesList($newServices)
    {
        $allData = [];

        foreach ($newServices as $services) {
            $agents = UserShopService::find()
                ->select('user_id')
                ->groupBy('user_id')
                ->having(['count(distinct service_id)' => count($services)])
                ->andWhere(['service_id' => $services])
                ->all();

            if ($agents) {
                $allData[] = [
                    'services' => $services,
                    'agents' => $agents,
                ];
            }
        }

        return $allData;
    }

    public function getUniqueServices($servSet, $size)
    {
        $result = $this->allSubsets($servSet, $size);
        return $result;
    }

    public function allSubsets($set, $size)
    {
        $subsets = [];
        if ($size == 1) {
            return array_map(function ($v) {
                return [$v];
            }, $set);
        }
        foreach ($this->allSubsets($set, $size - 1) as $subset) {
            foreach ($set as $element) {
                if (!in_array($element, $subset)) {
                    $newSet = array_merge($subset, [$element]);
                    sort($newSet);
                    if (!in_array($newSet, $subsets)) {
                        $subsets[] = array_merge($subset, [$element]);
                    }
                }
            }
        }
        return $subsets;
    }


    public function vat()
    {
        $settings = Settings::findOne(1);

        if ($settings->taxes_type == Settings::SERVICE_FEE_TYPE_FIXED) {
            $this->vat = $settings->taxes;

        } else {

            $this->vat =$this->amount *  $settings->taxes  / 100;

        }

    }

    public function discount_value($type, $code_value, $total_service_amount)
    {

        if ($type == PromoCode::TYPE_FIXED_AMOUNT) {
            $this->promo_code_value = $code_value;

        } else {

            $this->promo_code_value = $code_value * $total_service_amount / 100;

        }

    }

    public function allServicesHaveSameShop($services)
    {
        $firstService = null;
        $allServicesHaveSameShop = true;

        foreach ($services as $service) {
            $this->amount += $service->service_amount;

            if ($firstService === null) {
                $firstService = $service->shop_id;
            } else {
                if ($service->shop_id !== $firstService) {
                    $allServicesHaveSameShop = false;
                    break;
                }
            }
        }

        if ($allServicesHaveSameShop) {
            $this->shop_id = $firstService;
        } else {
            return false;
        }
        return true;

    }


}
