<?php
namespace api\models;

use api\controllers\UserController;
use api\helpers\ImageHelper;
use api\helpers\ResponseHelper;
use common\models\User;
use common\models\UserProfile;
use Yii;
use yii\base\Model;
use yii\rbac\Role;

/**
 * Model representing  Signup Form.
 */
class UserForm extends Model
{
    const SCENARIO_UPDATE = 'upload_files';
    
    public $username;
    public $name;
    public $email;
    public $mobile;
    public $status;
    public $birth_date;

    public $password;
    public $new_password;
    public $old_password;
    public $binary_image ;

    public $permit;
    public $national_id ;

    public $user_type;
    public $age;
    public $gender;
    public $locale;
    public $education_level;
    public $skills = [] ;
    public $language = [];
    public $language_id;
    public $hour_rate ;
    public $preferred_age ;
    public $license_no ;
    public $bio ;

    public $preferred_age_to_unit;
    public $preferred_age_to;
    public $preferred_age_from_unit;
    public $preferred_age_from;


    /**
     * Returns the validation rules for attributes.
     *
     * @return array
     */
    public function rules()
    {
        return [
            [['email','name','mobile'], 'required'], //'mobile'
            ['email', 'filter', 'filter' => 'trim'],
            ['email', 'email'],
            [['email','username','name','new_password','locale'], 'string', 'max' => 200],
            ['email', 'unique', 'targetClass' => '\common\models\User',
                'message' => 'البريد الألكتروني مستخدم من قبل.', 'when' => function ($model){
        return $model->email != Yii::$app->user->identity->email;
             }],
            ['mobile', 'unique', 'targetClass' => '\common\models\User',
                'message' => 'Mobile number is used before' ,
                'when' => function ($model){
                    return $model->mobile != Yii::$app->user->identity->mobile;
                }],
            [['binary_image','license_no','bio','old_password','skills','language_id','language','preferred_age', 'permit','birth_date', 'national_id'],'safe'],
            
//            [['permit', 'national_id'], 'required', 'on' => self::SCENARIO_UPDATE],

            [['preferred_age_to_unit','preferred_age_to','preferred_age_from_unit',
                'preferred_age_from','education_level' ], 'integer'],
            ['hour_rate','number'],
            [['preferred_age_to_unit','preferred_age_to','preferred_age_from_unit',
                'preferred_age_from','gender' ], 'integer'],
            [['age','user_type'],'number'],

            ['national_id', 'file', 'maxSize' => 1024 * 1024 * 2, 'on' => self::SCENARIO_UPDATE],

        ];
    }

    public function scenarios()
    {
        $scenarios = parent::scenarios();
        $scenarios[self::SCENARIO_UPDATE] = ['permit', 'national_id'];
        return $scenarios;
    }

    /**
     * Returns the attribute labels.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return [
            'new_password' => Yii::t('common', 'Password'),
            'password_repeat' => Yii::t('common', 'Repeat Password'),
            'mobile' => Yii::t('common', 'Mobile Number'),
        ];
    }

    public function save()
    {
        if (!$this->validate()) {
            return false;
        }

        $user = User::findOne(['id'=> \Yii::$app->user->identity->getId()]) ;
        $profile = $user->userProfile;

        $user->username =   $this->email;
        $user->email =   $this->email;
        $user->user_type = $this->user_type ;
        $user->full_name = $this->name ;
        $user->mobile =myClearPhone($this->mobile) ;

        $profile->gender = $this->gender;
        $profile->birth_date = $this->birth_date;
        $profile->locale = $this->locale;
        if($this->new_password != ""){
            if(! $this->old_password )  return 0 ;
            $valid_password = Yii::$app->getSecurity()->validatePassword(  $this->old_password , $user->password_hash);
            if(! $valid_password )  return 0 ;
            $user->setPassword($this->new_password);
        }
        $profile->firstname = $this->name;
        $profile->license_no = $this->license_no;
        $profile->bio = $this->bio;
        $profile->nationality_id = $this->national_id;
        $profile->language_id = $this->language_id;

//       if($this->age) $profile->age = $this->age ;
//        if($this->preferred_age_to_unit ) $profile->preferred_age_to_unit = $this->preferred_age_to_unit ;
//        if($this->preferred_age_to) $profile->preferred_age_to = $this->preferred_age_to ;
//        if($this->preferred_age_from_unit)$profile->preferred_age_from_unit = $this->preferred_age_from_unit ;
//        if($this->preferred_age_from)   $profile->preferred_age_from = $this->preferred_age_from ;
//        if($this->education_level) $profile->education_level = $this->education_level ;
//        if($this->hour_rate) $profile->hour_rate = $this->hour_rate ;
       //to be calculated
       // $profile->from_days  $profile->to_days



        if($profile->save() && $user->save()){
            return true;
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>array_merge($profile->errors,$user->errors)]);
        }
    }

    public function MinifyUsername()
    {
        $username = str_replace(" ", "_", $this->username);
        $username = $username . '_' .rand(100,1500000);
        return $username;
    }
}
