<?php
namespace api\models;

use api\controllers\UserController;
use api\helpers\ImageHelper;
use api\helpers\ResponseHelper;
use common\models\User;
use common\models\UserProfile;
use Yii;
use yii\base\Model;
use yii\rbac\Role;

/**
 * Model representing  Signup Form.
 */
class UserSignup extends Model
{
    public $username;
    public $email;
    public $name;
    public $invitation_code;
    public $birth_date;
    public $gender;
    public $otp;
    public $password;
    public $password_repeat;
    public $status;
    public $binary_image ;
    public $mobile ;
    public $user_type;
    public $firebase_token;

    /**
     * Returns the validation rules for attributes.
     *
     * @return array
     */
    public function rules()
    {
        return [
            [['email', 'password','mobile'], 'required'],
            ['email', 'filter', 'filter' => 'trim'],
            ['email', 'email'],
            ['mobile', 'unique', 'targetClass' => '\common\models\User',
                'message' => 'Mobile number is used before'],
            [['email','mobile','password','username','name','invitation_code','birth_date'], 'string', 'max' => 200],
            ['email', 'unique', 'targetClass' => '\common\models\User',
                'message' => 'البريد الألكتروني مستخدم من قبل.'],
//            ['otp', 'unique', 'targetClass' => '\common\models\UserProfile',
//                'message' => 'Mobile number is used before'],
            [['binary_image', 'firebase_token'],'safe'],
            [['user_type','gender'],'integer']


        ];
    }

    /**
     * Returns the attribute labels.
     *
     * @return array
     */
    public function attributeLabels()
    {
        return [
            'password' => Yii::t('common', 'Password'),
            'password_repeat' => Yii::t('common', 'Repeat Password'),
            'otp' => Yii::t('common', 'otp'),
        ];
    }

    /**
     * Signs up the user.
     * If scenario is set to "rna" (registration needs activation), this means
     * that user need to activate his account using email confirmation method.
     *
     * @return User|null The saved model or null if saving fails.
     */
    public function signup()
    {
        
        $user = new User();
       // $this->username;
        //$user->username = $this->username;
        $user->mobile =  UserController::$prefix . myClearPhone($this->mobile);
        $user->username = $user->email = $this->email;
        $user->setPassword($this->password);
        $user->generateAuthKey();
        $user->status = User::STATUS_ACTIVE;
        $user->full_name = $this->name;

        $user->firebase_token = $this->firebase_token;

        $user->user_type = User::USER_TYPE_CUSTOMER;
        if ($user->save()) {
            $auth = Yii::$app->authManager;
            $role = $auth->getRole(User::ROLE_USER);
            $auth->assign($role, $user->id);

            $profile = new UserProfile();
            $profile->gender = $this->gender;
            $profile->birth_date = $this->birth_date;
            $profile->invitation_code = $this->invitation_code;
           // $profile->mobile = $this->mobile;
            $profile->locale = 'en';
            if($this->binary_image){
                $filename = ImageHelper::Base64Image($this->binary_image);
                $profile->avatar_base_url = \Yii::getAlias('@storageUrl') . '/source/';
                $profile->avatar_path = 'profile/' . $filename;
            }
            $user->link('userProfile', $profile);

            return $user;
        }
        return $user;

    }



    public function save()
    {
        if (!$this->validate()) {
            return false;
        }

        $user = User::findOne(['id'=> \Yii::$app->user->identity->getId()]) ;
        $profile = $user->userProfile;

        //$user->username = $this->username ;
        if($this->email){
            $user->username = $user->email = $this->email;
        }
       // $user->phone = $this->phone;
        if($this->name){
            $profile->firstname = $this->name;
        }

        if($this->new_password != ""){
            $user->setPassword($this->new_password);
        }
       // $profile->mobile = $this->phone;
        $this->binary = $this->avatar ? $this->avatar : $this->binary;

         if($profile->save(false) && $user->save()){
            return true;
        }else{
            return ResponseHelper::sendFailedResponse(['MESSAGE'=>array_merge($profile->errors,$user->errors)]);
        }
    }


    public function getSettings()
    {
        return \backend\models\Settings::findOne(1);
    }

    public function MinifyUsername()
    {
        $username = str_replace(" ", "_", $this->username);
        $username = $username . '_' .rand(100,1500000);
        return $username;
    }
}
