<?php

namespace api\resources;

use common\models\User;

class AgentResource extends User
{
    public function fields()
    {
        return [
            'id',
            'name' => function ($model) {
                return $model->full_name;
            },
            'image' => function ($model) {
                return $model->userProfile->getNewAvatar()?:null;
            },
            'from_hours' => function ($model) {
                return $model->userProfile->from_hours;
            },
            'to_hours' => function ($model) {
                return $model->userProfile->to_hours;
            },
            'mobile',
            'rate' => function($model){
                return [
                    'rate_average' => $model->rate_average,
                    'total_rates' => $model->ratesCount,
                ];
            },

//            'slots' => function ($model) {
//                return $model->agentSlots;
//            },
        ];
    }

}
