<?php

namespace api\resources;

use common\models\Booking;

class BookingResource extends Booking
{
    public function fields()
    {
        return [
            'id',

            'status',
            'booking_date',
            'from_hour',
            'to_hour',
            'name',
            'email',
            'mobile',
            'tipping_amount',
            'tipping_status',
            'amount' => function ($model) {
                return $model->sub_amount;
            },
            'vat',
            'discount_value',
            'total_paid' => function ($model) {
                return $model->total_amount;
            },
            'extended_booking_id',
            'total_with_extend',
            'promo_code_id' => function ($model) {
                return $model->promo_code_id;
            },
            'services_num' => function ($model) {
                return $model->getBookingServices()->count();
            },

            'agent' => function ($model) {
                return $model->agent?:null;
            },
            'customer' => function ($model) {
                return $model->customer?:null;
            },
            'shop' => function ($model) {
                return [
                    'id' => $model->shop->id ?: null,
                    'name' => $model->shop->title ?: null,
                    'image' => $model->shop->getImage() ?: null,
                    'slot_time_step' => $model->shop->slot_time_step ?: null,
                    'limited_schedule_days' => $model->shop->limited_schedule_days ?: null,
                ];
            },

            'booking_services' => function ($model) {
                return $model->bookingServices;
            },
            'reason' => function ($model) {
                return $model->reason?:"";
            },
            'rate' => function(){
                $requestRates = RequestRateResource::find()->where(['request_id' => $this->id ])->all();
                $agent =[];
                $customer =[];
                foreach($requestRates as $rate){
                    if($rate->user->user_type != 0){
                        $agent['review'] = $rate['user_review'];
                        $agent['review_stars'] = $rate['user_rating'];
                        $agent['created_at'] = $rate['created_at'];
                    }else{
                        $customer['review'] = $rate['user_review'];
                        $customer['review_stars'] = $rate['user_rating'];
                        $customer['created_at'] = $rate['created_at'];
                    }
                }
                return [
                    'agent'=> (!empty($agent)) ? $agent : null,
                    'customer' => (!empty($customer)) ? $customer : null,
                ];
            },
            'created_at' => function ($model) {
                return $model->created_at;
            },

        ];

    }

}
