<?php

namespace api\resources;

use common\models\Conversation;
use common\models\Rate;

class ChatResource extends Conversation
{
    public function fields()
    {

        return [
            'id',
            'booking_id',
            'agent' => function () {
                return [
                    'id' => $this->agent->id,
                    'name' => $this->agent->full_name,
                    'mobile' => $this->agent->mobile,
                    'avatar' => $this->agent->userProfile->getNewAvatar(),
                    'email' => $this->agent->email,
                    'available' =>true ,
                ];
            },
            'customer' => function () {
                return [
                    'id' => $this->customer->id,
                    'name' => $this->customer->full_name,
                    'mobile' => $this->customer->mobile,
                    'avatar' => $this->customer->userProfile->getNewAvatar(),
                    'email' => $this->customer->email,
                    'available' =>true ,

                ];
            },
            'unseen_message_count'=> function () {
                return $this->unseen_message_count();
            },
            'message' => function () {
                return [
                    'message' => $this->messages,
                ];
            },
            'created_at' => function () {
                return ($this->created_at);
            },
            'last_update' => function () {
                return ($this->last_update);
            }
        ];
    }

}
