<?php

    namespace api\resources;
    use common\models\CustomerRelative;

    class CustomerRelativeResource extends \common\models\CustomerRelative
    {
        public function fields()
        {
            return [
                'id',
                'fullname',
                'age',
                'notes'=> function ($model) {
                    return $this->notes ?: "لا يوجد";
                },
                'medical_condition'=> function ($model) {
                    return  ['id'=> $this->medical_condition_id, 'title'=>$this->condition->title ] ?: [];
                },                
                'emergency_phones' => function ($model) {
                    return explode(',',$this->emergency_phones);
                },
                'created_at' => function ($model) {
                    return $model->created_at ;
                },
            ];

        }

    }
