<?php

namespace api\resources;
use common\models\CustomerRequest;

class CustomerRequestResource extends \common\models\CustomerRequest
{
    public function fields()
    {
        return [
            'id',
            'type',
            // Request Location Details
            'location' => function($model){
                return[                    
                    'address' => $this->address ?: "",
                    'lat' => $this->lat ?: "",
                    'lng' => $this->lng ?: ""
                ];
            },
            'created_at' => function ($model) {
                return $model->created_at;
            },
            'need_to' => function () {
                return $this->getRequestServiceTypes()[$this->need_to];
            },
            'needed_role' => function () {
                return $this->getRequestNeededRole()[$this->needed_role];
            },
            'working_place' => function () {
                return $this->getWorkingPlace()[$this->working_place];
            },
            'session_date',
            'session_time' => function($model){
                return ($this->session_time) ? strtotime($this->session_date.' '.$this->session_time) : null;
            },
            'main_session_time' => function($model){
                return $this->session_time;
            },
            'session_period',
            'total_session_period',
            'relatives' => function ($model) {
                return $model->allRelatives;
            },
            'nanny' => function () {
                return [
                    'id'=>$this->nany_id,
                    'name'=>$this->nanny->userProfile->fullName,
                    'avatar'=>$this->nanny->userProfile->avatar,
                    'email'=>$this->nanny->email,
                    'phone'=>$this->nanny->mobile,
                    'hour_rate' => $this->nanny->userProfile->hour_rate
                ];
            },
            'status'=> function($model){
                return[
                    'status_id' => $this->status,
                    'status_text' => $this->statuses()[$this->status],
                ];
            },
            
            'amount',
            'added_taxes',
            'paid_amount',  
            'nany_profit',
            'refund_to',
            'refunded_amount',
            'customer_refunded_amount',
            'payment_status' => function()
            {
                return [
                    'status_code' => $this->payment_status ,
                    'status_text' => $this->getPaymentStatus()[$this->payment_status] 
                ];
            },
            
            'tracking_status'=> function(){
                return [
                    'id'=>$this->request_tracking_status,
                    'value'=> CustomerRequest::RequestStatusTrackingList()[$this->request_tracking_status]
                ];
            },
            'request_tracking_log'=> function(){
                $requestLogs = RequestTrackingLogResource::find()->where(['request_id' => $this->id ])->all();
                return $requestLogs;
            },
            'offers_count' => function () {
                return $this->offersCount;
            },
            // Customer main Details
            'customer' => function () {
                return [
                    'id'=>$this->user_id,
                    'name'=>$this->user->userProfile->fullName,
                    'avatar'=>$this->user->userProfile->avatar,
                    'email'=>$this->user->email,
                    'phone'=>$this->user->mobile,

                    'rate_average' => $this->user->rate_average,
                    'total_rates' => $this->user->ratesCount,
                ];
            },
            'rate' => function(){
                $requestRates = RequestRateResource::find()->where(['request_id' => $this->id ])->all();
                $nany =[];
                $customer =[];
                foreach($requestRates as $rate){
                    if($rate->user->user_type != 0){
                        $nany['review'] = $rate['user_review'];
                        $nany['review_stars'] = $rate['user_rating'];
                    }else{
                        $customer['review'] = $rate['user_review'];
                        $customer['review_stars'] = $rate['user_rating'];
                    }                                        
                }
                return [
                    'nany'=> (!empty($nany)) ? $nany : null,
                    'customer' => (!empty($customer)) ? $customer : null,
                ];
            },

            'extended',
            'location_available',
        ];
    }

}
