<?php

namespace api\resources;

use common\models\User;

class CustomerResource extends User
{
    public function fields()
    {
        return [
            'id',
            'name' => function ($model) {
                return $model->full_name;
            },
            'rate' => function ($model) {
                return $model->rate_average;
            },
            'mobile' => function ($model) {
                return $model->mobile;
            },
            'image' => function ($model) {
                return $model->userProfile->getNewAvatar()?:null;
            },
//            'slots' => function ($model) {
//                return $model->agentSlots;
//            },
        ];
    }

}
