<?php

namespace api\resources;

use common\models\ExtendedBooking;

class ExtendedBookingResource extends ExtendedBooking
{
    public function fields()
    {
        return [
            'id',

            'status',
            'booking_date',
            'from_hour',
            'to_hour',
            'name',
            'email',
            'mobile',
            'invoice_id',
            // 'tipping_amount',
            // 'tipping_status',
            'amount' => function ($model) {
                return $model->sub_amount;
            },
            'vat',
            'discount_value',
            'total_paid' => function ($model) {
                return $model->total_amount;
            },
            'promo_code_id' => function ($model) {
                return $model->promo_code_id;
            },
            'services_num' => function ($model) {
                return $model->getBookingServices()->count();
            },

            // 'agent' => function ($model) {
            //     return $model->agent?:null;
            // },

            // 'customer' => function ($model) {
            //     return $model->customer?:null;
            // },

            'agent' => function () {
                return [
                    'id'=>$this->agent_id,
                    'name'=>$this->agent->full_name,
                    'image'=>$this->agent->userProfile->newAvatar,
                    'email'=>$this->agent->email,
                    'phone'=>$this->agent->mobile,

                    'rate_average' => $this->customer->rate_average,
                    'total_rates' => $this->customer->ratesCount,
                ];
            },

            'customer' => function () {
                return [
                    'id'=>$this->customer_id,
                    'name'=>$this->customer->full_name,
                    'image'=>$this->customer->userProfile->newAvatar,
                    'email'=>$this->customer->email,
                    'phone'=>$this->customer->mobile,


                    'rate_average' => $this->customer->rate_average,
                    'total_rates' => $this->customer->ratesCount,
                ];
            },


            'shop' => function ($model) {
                return [
                    'id' => $model->shop->id ?: null,
                    'name' => $model->shop->title ?: null,
                    'image' => $model->shop->getImage() ?: null,
                ];
            },

            'booking_services' => function ($model) {
                return $model->bookingServices;
            },

            'created_at' => function ($model) {
                return $model->created_at;
            },

        ];

    }

}
