<?php
    namespace api\resources;
    use common\models\Notifications;
    use common\models\CustomerRequest;
    use common\models\ExtendedRequests;
    use common\models\RequestLog;
    use common\models\User;
    use common\models\Booking;

    class NotificationsResource extends \common\models\Notifications
    {
        public function fields()
        {
            return [
                'id',                   
                'key_id',
                'topic',
                'from' => function($model){
                    return [
                        'from_id' => $model->from_id,
                        'from_name' => $model->fromUser->userProfile->fullName,
                    ];
                },
                'to' => function($model){
                    return [
                        'to_id' => $model->to_id,
                        'to_name' => $model->fromUser->userProfile->fullName,
                    ];
                },
                'module',
                'module_id',
                'title_ar',
                'message_ar',
                'title_en',
                'message_en',
                'request_id',
                'action',
                'seen',
                'route',
                'payload' => function(){
                    return json_decode($this->payload, true);
                },

                'shop_category_id' => function(){
                    if($this->module == "booking"){
                        $booking = Booking::findOne($this->module_id);

                        return ($booking->shop) ? $booking->shop->category_id : null;
                    }
                    
                },

//                'request_status' => function()
//                {
//                    if($this->module == "request")
//                    {
//                        $user = User::findOne($this->to_id);
//                        if($user->user_type == 0)
//                        {
//                            $requestObj = CustomerRequest::findOne($this->module_id);
//                        }else{
//                            $requestLog = RequestLog::findOne($this->module_id);
//                            $requestObj = CustomerRequest::findOne($requestLog->request_id);
//                        }
//
//                        return [
//                            'status_id' => $requestObj->status,
//                            'status_text' => $requestObj->statuses()[$requestObj->status],
//                        ];
//                    }
//                },

//                'tracking_status'=> function(){
//                    if($this->module == "request")
//                    {
//                        $user = User::findOne($this->to_id);
//                        if($user->user_type == 0)
//                        {
//                            $requestObj = CustomerRequest::findOne($this->module_id);
//                        }else{
//                            $requestLog = RequestLog::findOne($this->module_id);
//                            $requestObj = CustomerRequest::findOne($requestLog->request_id);
//                        }
//
//                        return [
//                            'id'=>$requestObj->request_tracking_status,
//                            'value'=> CustomerRequest::RequestStatusTrackingList()[$requestObj->request_tracking_status]
//                        ];
//                    }
//                },
//
//                'request_tracking_log'=> function()
//                {
//                    if($this->module == "request")
//                    {
//                        $user = User::findOne($this->to_id);
//                        if($user->user_type == 0)
//                        {
//                            $requestObj = CustomerRequest::findOne($this->module_id);
//                        }else{
//                            $requestLog = RequestLog::findOne($this->module_id);
//                            $requestObj = CustomerRequest::findOne($requestLog->request_id);
//                        }
//
//                        $requestLogs = RequestTrackingLogResource::find()->where(['request_id' => $requestObj->id ])->all();
//                        return $requestLogs;
//                    }
//                },
//
//                'extend_request_status' => function()
//                {
//                    if($this->key_id == Notifications::TYPE_UPDATE_EXTEND_SESSSION_STATUS || $this->key_id == Notifications::TYPE_EXTEND_SESSION)
//                    {
//                        $user = User::findOne($this->to_id);
//                        if($user->user_type == 0)
//                        {
//                            $requestObj = ExtendedRequests::find()->where(['request_id' => $this->module_id])->orderBy('id DESC')->one();
//                        }else{
//                            $requestLog = RequestLog::findOne($this->module_id);
//                            $requestObj = ExtendedRequests::find()->where(['request_id' => $requestLog->request_id])->orderBy('id DESC')->one();
//                        }
//
//
//                        return [
//                            'status_id' => $requestObj->status,
//                            'status_text' => $requestObj->statuses()[$requestObj->status],
//                        ];
//                    }
//                },

                'created_at' => function ($model) {
                    return $model->created_at ;
                },
            ];

        }

    }
