<?php

namespace api\resources;

use common\models\base\Package;
use common\models\PackagesService;


class PackagesServiceResource extends Package
{

    public function fields()
    {
        return [
            'id',
            'name',
            'price',
            'period' => function ($model) {
                return  $model->period;
            },
            'service_num' => function ($model) {
                return  $model->getPackagesServices()->count();
            },
            'agents' => function ($model) {
                return  $model->users;
            },
            'services' => function ($model) {
                return  $model->services;
            },
            'image' => function ($model) {
                return  $model->getImage();
            },

        ];
    }



}