<?php

namespace api\resources;
use common\models\CustomerRequest;

class PaymentResource extends \common\models\CustomerRequest
{
    public function fields()
    {
        return [
            'id',

            'created_at' => function ($model) {
                return $model->created_at;
            },

            'session_date',

            'session_time' => function($model){                
                return ($this->session_time) ? strtotime($this->session_date.' '.$this->session_time) : null;
            },
            
            'main_session_time' => function($model){
                return $this->session_time;
            },

            'session_period',

            'nanny' => function () {
                return [
                    'id'=>$this->nany_id,
                    'name'=>$this->nanny->userProfile->fullName,
                    'avatar'=>$this->nanny->userProfile->avatar,
                    'email'=>$this->nanny->email
                ];
            },
            
            'amount',
            'paid_amount',                     
        ];

    }

}
