<?php

namespace api\resources;

use common\models\Offer;

class RequestOffersResource extends \common\models\Offer
{
    public function fields()
    {
        return [
            'id',
            'price',
            'nanny' => function($model){                
                return [
                    'id' => $model->nany_id,
                    'name' => $model->nany->userProfile->fullName,
                    'avatar' => $model->nany->userProfile->avatar,
                    'total_rate'=> $model->nany->rate_average,
                    'raters_count'=> $model->nany->ratesCount,
                ];
            },
            'request' => function($model){                
                return [
                    'request_id' => $model->request_id, 
                    'session_period' => $model->request->session_period,
                ];
            },
            'created_at',
        ];

    }

}
