<?php
namespace api\resources;
use common\models\Rate;

class RequestRateResource extends Rate
{
    public function fields()
    {

        return [
            'id',
            'request_id',             
            'agent' => function ($model) {
                if($model->user->user_type != 0)
                return [
                    'review'=> $this->user_review,
                    'review_stars' => $this->user_rating,
                    'created_at' => $this->created_at,
                ];
                return [];
            },
            'customer' => function ($model) {
                if($model->user->user_type == 0)
                return [
                    'review'=> $this->user_review,
                    'review_stars' => $this->user_rating,
                    'created_at' => $this->created_at,
                ];
                return [];
            },            
        ];
    }

}
