<?php

namespace api\resources;

use common\models\CustomerRequest;
use common\models\RequestLog;

class RequestResource extends \common\models\RequestLog
{
    public function fields()
    {
        return [

            'id',//refers to log not request

            'type',

            'created_at' => function () {
                return $this->request->created_at ;
            },

            'kids_number' => function () {
                return $this->request->allRelativesCount;
            },
            
            // Request Details
            'need_to' => function(){
                return $this->request->getRequestServiceTypes()[$this->request->need_to];
            },

            'needed_role' => function(){
                return $this->request->getRequestNeededRole()[$this->request->needed_role];
            },

            'session_date' => function () {
                return $this->request->session_date;
            },
            'session_time' => function () {
                return ($this->request->session_time) ? strtotime($this->request->session_time) : null;
            },
            'session_period' => function () {
                return $this->request->session_period;
            },

            'working_place'=> function(){
                return $this->request->getWorkingPlace()[$this->request->working_place];
            },

            'relatives'=> function(){
                return $this->request->allRelatives;
            },
            'address'=> function () {
                return $this->request->user->userProfile->address?: null;
            },

            'offers_count' => function () {
                return $this->request->offersCount;
            },

            // Customer main Details       
            'customer' => function () {
                return [
                    'id'=>$this->request->user_id,
                    'name'=>$this->request->user->userProfile->fullName,
                    'avatar'=>$this->request->user->userProfile->avatar,
                    'email'=>$this->request->user->email
                ];
            },

            'location' => function($model){
                return[                    
                    'address' => $this->request->address ?: "",
                    'lat' => $this->request->lat ?: "",
                    'lng' => $this->request->lng ?: ""
                ];
            },

            'status'=> function($model){
                return[
                    'status_id' => $this->request->status,
                    'status_text' => $this->request->statuses()[$this->status],
                ];
            },
            'tracking_status'=> function(){
                return [
                    'id'=>$this->request->request_tracking_status,
                    'value'=> CustomerRequest::RequestStatusTrackingList()[$this->request->request_tracking_status]
                ];
            },

            'total_rate'=> function(){
                return 4;
            },
            'raters_count'=> function(){
                return 15;
            },


        ];

    }

}
