<?php

namespace api\resources;

use common\models\Shop;

class ShopsResource extends \common\models\Shop
{
    public function fields()
    {
        return [
            'id',
            'title',       
            'city' => function(){
                return $this->cityName->name;
            },
            'district' => function(){
                return $this->districtName->name;
            },
            'rate' => function($model){

                return [
                    'rate_average' => $model->rate,
                    'total_rates' => $model->total_rates.'',
                ];
            },
            'open_at',
            'close_at',
            'about',
            'mobile',
            'address',
            'address_text',
            'shop_category'=>function(){
                return $this->id;
            },
            'owner' => function () {
                return [
                    'id'=>$this->user_id,
                    'name'=>$this->user->userProfile->fullName,
                    'avatar'=>$this->user->userProfile->getNewAvatar(),
                    'email'=>$this->user->email,
                    'mobile'=>$this->user->mobile,
                ];
            },
            'location' => function($model){
                return[                    
                    'address' => $this->address_text ?: "",
                    'lat' => $this->lat ?: "",
                    'lng' => $this->lng ?: ""
                ];
            },

            'status'=> function($model){
                return[
                    'status_id' => $this->status,
                    'status_text' => $this->statuses()[$this->status],
                ];
            },
            'image' => function ($model) {
                return  $model->getImage();
            },
            'slot_time_step' => function ($model) {
                return  $model->slot_time_step;
            },
            'limited_schedule_days' => function ($model) {
                return  $model->limited_schedule_days;
            },
            'gallery' => function ($model) {
                return  $model->getUploadedFilesPath();
            },
            'created_time' => function ($model) {
                return  $model->created_at;
            },
            'terms_conditions' => function ($model) {
                return  $model->terms_conditions?:"";
            },
            'cancel_terms' => function ($model) {
                return  $model->cancel_terms?:"";
            },
        ];
    }

}
