<?php

namespace api\resources;
use common\models\TechnicalSupport;

class TechnicalSupportResource extends \common\models\TechnicalSupport
{
    public function fields()
    {
        return [
            'id',
            'subject',
            'details',
            'user' => function () 
            {
                return [
                    'id'=>$this->user_id,
                    'name'=>$this->user->userProfile->fullName,
                    'avatar'=>$this->user->userProfile->avatar,
                    'email'=>$this->user->email,
                    'user_type' => $this->user->user_type,
                    'phone'=>$this->user->mobile
                ];
            },

            'created_at' => function ($model) {
                return $model->created_at;
            },                             
        ];

    }

}
