<?php

namespace api\resources;

class UserResource extends \common\models\User
{
    public function fields()
    {
        if ($this->user_type ===self::USER_TYPE_CUSTOMER ) {

            return [
                'profile_status' => function ($model) {
                    return 1;
                },
                'id',
                'name' => function ($model) {
                    return $model->full_name;
                },
                'birth_date' => function ($model) {
                    return $model->userProfile->birth_date;
                },
                'gender' => function ($model) {
                    return $model->userProfile->gender;
                },
                'email',
                'mobile',
                'firebase_token',
                'status',
                'status_text' => function ($model) {
                    return $this->statuses()[$this->status];
                },
                'user_type',                         
                'image' => function ($model) {
                    return $this->userProfile->getNewAvatar() ?: "";
                },
                'invitation_code' => function ($model) {
                    return $this->userProfile->invitation_code ?: "";
                },

                'language' => function ($model) {
                    return $this->userProfile->language ?: null;
                },
                
//                'distance',
                
                'location' => function ($model) {
                    return [
                        'address' => $model->userProfile->address ?: null,
                        'lat' => $model->userProfile->lat ?: null,
                        'lng' => $model->userProfile->lng ?: null,
                    ];
                },

                'rate' => function($model){
                    return [
                        'rate_average' => $model->rate_average,
                        'total_rates' => $model->ratesCount,
                    ];
                },
//                'requests_count' => function()
//                {
//                    return $this->customerRequestsCount;
//                },
                'joined_at' => function ($model) {
                    return $model->created_at;
                },

                'invitation_id' => function ($model) {
                    return strtoupper(substr($model->email, 0, 4)) . $model->id;
                },
//                'locale' => function ($model) {
//                    return $model->userProfile->locale;
//                },

            ];
        } else {

            return [
                'profile_status' => function ($model) {
                    return 1;
                },
                'id',
                'name' => function ($model) {
                    return $model->full_name;
                },
                'birth_date' => function ($model) {
                    return $model->userProfile->birth_date;
                },
                'gender' => function ($model) {
                    return $model->userProfile->getUserGender();
                },
                'mobile',
                'email',
                'firebase_token',
                'status',
                'status_text' => function ($model) {
                    return $this->statuses()[$this->status];
                },
                'user_type',
                'image' => function ($model) {
                    return $this->userProfile->getNewAvatar() ?: "";
                },
                'bio' => function ($model) {
                    return $this->userProfile->bio ?: "";


                },
                'license_no' => function ($model) {
                    return $this->userProfile->license_no ?: "";
                },
                'nationality' => function ($model) {
                    return $this->userProfile->nationality ?: null;
                },
                'language' => function ($model) {
                    return $this->userProfile->language ?: null;
                },
                'shop_name' => function ($model) {
                    return $this->work->title ?: "";
                },
                'slot_time_step' => function () {
                    return  $this->work->slot_time_step;
                },
                'limited_schedule_days' => function () {
                    return  $this->work->limited_schedule_days;
                },
//                'distance',

//                'location' => function ($model) {
//                    return [
//                        'id' => $model->userProfile->location_id ?: null,
//                        'address' => $model->userProfile->address ?: null,
//                        'lat' => $model->userProfile->lat ?: null,
//                        'lng' => $model->userProfile->lng ?: null,
//                    ];
//                },

                'rate' => function($model){
                    return [
                        'rate_average' => $model->rate_average,
                        'total_rates' => $model->ratesCount,
                    ];
                },
//                'requests_count' => function()
//                {
//                    return $this->customerRequestsCount;
//                },
                'joined_at' => function ($model) {
                    return $model->created_at;
                },
//                'locale' => function ($model) {
//                    return $model->userProfile->locale;
//                },

                'from_hours' => function ($model) {
                    return $model->userProfile->from_hours;
                },
                'to_hours' => function ($model) {
                    return $model->userProfile->to_hours;
                },

            ];
        }
    }
}
