<?php

namespace api\resources;
use common\models\Payment;

class WalletResource extends \common\models\Payment
{
    public function fields()
    {
        return [
            'id',

            'created_at' => function ($model) {
                return $model->created_at;
            },
            'booking_id',

            'customer' => function($model){
                return [
                    'id'=>$this->user_id,
                    'name'=>$this->user->full_name,
                    'avatar'=>$this->user->userProfile->getNewAvatar(),
                    'email'=>$this->user->email,
                    'phone'=>$this->agent->mobile
                ];
            },

            'agent' => function($model){
                return [
                    'id'=>$this->agent_id,
                    'name'=>$this->agent->full_name,
                    'avatar'=>$this->agent->userProfile->getAvatar(),
                    'email'=>$this->agent->email,
                    'phone'=>$this->agent->mobile
                ];
            },


            'type',
            'amount',
            'paid_amount',
            'tran_ref',

            'withdrawal', // 0 not withdrawed, 1 withdrawed
            'extended', // 0 not extended, 1 extended
            'refunded', // 0 not refunded, 1 refunded
            'refunded_to', // 1 customer, 2 nanny & customer
//            'refunded_amount' => function($model){
//                return $model->request->refunded_amount;
//            },
        ];

    }

}
