<?php

namespace api\resources;
use common\models\User;
use common\models\Withdrawal;
use common\models\CustomerRequest;

class WithdrawalResource extends \common\models\Withdrawal
{
    public function fields()
    {
        return [
            'id',
            'created_at' => function ($model) {
                return $model->created_at;
            },
            'bank_account' => function($model){
                return [
                    'id'=>$this->account_id,
                    'name'=>$this->name,
                    'iban'=>$this->iban
                ];
            },
            'bank' => function($model){
                return [
                    'id'=>$this->bank_id,
                    'name'=>$this->bank->name                    
                ];
            },
            'agent' => function($model){
                return [
                    'id'=>$this->agent_id,
                    'name'=>$this->agent->full_name,
                    'avatar'=>$this->agent->userProfile->getNewAvatar(),
                    'email'=>$this->agent->email,
                    'phone'=>$this->agent->mobile
                ];
            },
            'total',
            'status'=> function($model){
                return[
                    'status_id' => $this->status,
                    'status_text' => $this->getStatus()[$this->status],
                ];
            },
            'withdrawal_type'=> function($model){
                return[
                    'withdrawal_type_id' => $this->withdrawal_type,
                    'withdrawal_type_text' => User::withdrawalType()[$this->withdrawal_type],
                ];
            },
        ];

    }

}
