<?php

namespace api\resources;
use common\models\BankAccount;

class BankAccountResource extends \common\models\BankAccount
{
    public function fields()
    {
        return [
            'id',
            'name',  
            'iban',

            'bank' => function () 
            {
                return [
                    'id'=>$this->bank_id,
                    'name'=>$this->bank->name,
                ];
            },

            'nany' => function () 
            {
                return [
                    'id'=>$this->nany_id,
                    'name'=>$this->nany->userProfile->fullName,
                    'avatar'=>$this->nany->userProfile->avatar,
                    'email'=>$this->nany->email,
                    'phone'=>$this->nany->mobile
                ];
            },

            'created_at' => function ($model) {
                return $model->created_at;
            },                             
        ];

    }

}
