<?php

namespace api\resources\agent;

use common\models\Booking;
use api\resources\RequestRateResource;

class BookingResource extends Booking
{
    public function fields()
    {
        return [
            'id',
            'status',
            'status_text' => function ($model) {
                return $model->statuses()[$model->status];
            },
            'booking_date',
            'from_hour',
            'to_hour',
            'total_amount',
            'extended_booking_id',
            'total_with_extend',
            'sub_amount',
            'vat',
            'discount_value',
            'tipping_amount',
            'tipping_status',
            'name' => function ($model) {
                return $model->name?:'';
            },
            'email' => function ($model) {
                return $model->email?:'';
            },
            'mobile' => function ($model) {
                return $model->mobile?:'';
            },
            'promo_code_id' => function ($model) {
                return $model->promo_code_id;
            },
            'services_num' => function ($model) {
                return $model->getBookingServices()->count();
            },
            'agent' => function ($model) {
                return $model->agent?:null;
            },
            'customer' => function ($model) {
                return $model->customer?:null;
            },
            'shop' => function ($model) {
                return [
                    'id' => $model->shop->id ?: null,
                    'name' => $model->shop->title ?: null,
                    'image' => $model->shop->getImage() ?: null,
                ];
            },
            'booking_services' => function ($model) {
                return $model->bookingServices;
            },
            'reason',

            'rate' => function()
            {
                $requestRates = RequestRateResource::find()->where(['request_id' => $this->id ])->all();
                $agent =[];
                $customer =[];
                foreach($requestRates as $rate){
                    if($rate->user->user_type != 0){
                        $agent['review'] = $rate['user_review'];
                        $agent['review_stars'] = $rate['user_rating'];
                        $agent['created_at'] = $rate['created_at'];
                    }else{
                        $customer['review'] = $rate['user_review'];
                        $customer['review_stars'] = $rate['user_rating'];
                        $customer['created_at'] = $rate['created_at'];
                    }                                        
                }
                return [
                    'agent'=> (!empty($agent)) ? $agent : null,
                    'customer' => (!empty($customer)) ? $customer : null,
                ];
            },
            'tipping_status' => function ($model) {
                return ($model->tipping_status > 0) ? $model->tipping_status : null ;
            },
            'created_at' => function ($model) {
                return $model->created_at;
            },  
            
            'created_by' => function ($model) {
                return [
                    'created_by_id' => $model->createdBy->user_type,
                    'created_by_text' => $model->createdBy->getUserType(),
                ];
            },  
        ];

    }

}
