<?php

namespace api\resources\agent;

use common\models\Booking;

class ExtendedBookingResource extends ExtendedBooking
{
    public function fields()
    {
        return [
            'id',

            'status',
            'booking_date',
            'from_hour',
            'to_hour',
            'name',
            'email',
            'mobile',
            'tipping_amount',
            'tipping_status',
            'amount' => function ($model) {
                return $model->sub_amount;
            },
            'vat',
            'discount_value',
            'total_paid' => function ($model) {
                return $model->total_amount;
            },
            'promo_code_id' => function ($model) {
                return $model->promo_code_id;
            },
            'services_num' => function ($model) {
                return $model->getBookingServices()->count();
            },

            'agent' => function ($model) {
                return $model->agent?:null;
            },
            'customer' => function ($model) {
                return $model->customer?:null;
            },
            'shop' => function ($model) {
                return [
                    'id' => $model->shop->id ?: null,
                    'name' => $model->shop->title ?: null,
                    'image' => $model->shop->getImage() ?: null,
                ];
            },

            'booking_services' => function ($model) {
                return $model->bookingServices;
            },

            'created_at' => function ($model) {
                return $model->created_at;
            },

        ];

    }

}
