<?php

namespace api\resources\nany;

use common\models\CustomerRequest;
use common\models\RequestLog;
use common\models\ExtendedRequests;
use api\resources\RequestTrackingLogResource;
use api\resources\RequestRateResource;

class ExtendedRequestsResource extends \common\models\ExtendedRequests
{
    public function fields()
    {        
        return [
            'id'=>function(){
                $requestLog = RequestLog::find()->where(['request_id' => $this->request_id, 'nany_id' => \Yii::$app->user->getId()])->one();
                return $requestLog->id;
            }, // refers to main request id                      
            'created_at' => function () {
                return $this->created_at ;
            },
            'extend_id' => function()
            {
                return $this->id;
            }, // refers to extended request id                       
            'session_date' => function () {
                return $this->session_date;
            },
            'session_time' => function () {
                return ($this->session_time) ? strtotime($this->session_time) : null;
            },
            'main_session_time' => function(){
                return $this->request->session_time;
            },
            'extended_period' => function () {
                return $this->extended_period;
            },    
            'total_session_period' => function () {
                return $this->request->total_session_period;
            },                              
            'status'=> function($model){
                return[
                    'status_id' => $this->status,
                    'status_text' => $this->request->RequestStatusExtendSessionList()[$this->status],
                ];
            },   
            'amount', 
            'added_taxes' => function () {
                return $this->added_taxes;
            },    
            'paid_amount' => function () {
                return $this->paid_amount;
            },  
            'nanny' => function () {
                return [
                    'id'=>$this->nany_id,
                    'name'=>$this->nany->userProfile->fullName,
                    'avatar'=>$this->nany->userProfile->avatar,
                    'email'=>$this->nany->email,
                    'phone'=>$this->nany->mobile,
                    'rate_average' => $this->nany->rate_average,
                    'total_rates' => $this->nany->ratesCount,
                ];
            },            
            // Customer main Details       
            'customer' => function () {
                return [
                    'id'=>$this->user_id,
                    'name'=>$this->user->userProfile->fullName,
                    'avatar'=>$this->user->userProfile->avatar,
                    'email'=>$this->user->email,
                    'phone'=>$this->user->mobile,
                    'rate_average' => $this->user->rate_average,
                    'total_rates' => $this->user->ratesCount,
                ];
            },
            'rate' => function(){
                $requestRates = RequestRateResource::find()->where(['request_id' => $this->request_id ])->all();
                $nany =[];
                $customer =[];
                foreach($requestRates as $rate){
                    if($rate->user->user_type != 0){
                        $nany['review'] = $rate['user_review'];
                        $nany['review_stars'] = $rate['user_rating'];
                    }else{
                        $customer['review'] = $rate['user_review'];
                        $customer['review_stars'] = $rate['user_rating'];
                    }                                        
                }
                return [
                    'nany'=> (!empty($nany)) ? $nany : null,
                    'customer' => (!empty($customer)) ? $customer : null,
                ];
            },
            'extended'=>function(){
                return $this->request->extended;
            },
            'location' => function(){
                return[                    
                    'address' => $this->request->address ?: "",
                    'lat' => $this->request->lat ?: "",
                    'lng' => $this->request->lng ?: ""
                ];
            },
            'location_available'=>function(){
                return $this->request->location_available;
            },
            'relatives' => function ($model) {
                return $model->request->allRelatives;
            },
            'need_to' => function () {
                return $this->request->getRequestServiceTypes()[$this->request->need_to];
            },
            'needed_role' => function () {
                return $this->request->getRequestNeededRole()[$this->request->needed_role];
            },
            'working_place' => function () {
                return $this->request->getWorkingPlace()[$this->request->working_place];
            },
            'tracking_status'=> function(){
                return [
                    'id'=>$this->request->request_tracking_status,
                    'value'=> CustomerRequest::RequestStatusTrackingList()[$this->request->request_tracking_status]
                ];
            },
            'request_tracking_log'=> function(){
                $requestLogs = RequestTrackingLogResource::find()->where(['request_id' => $this->request_id ])->all();
                return $requestLogs;
            },
            'offers_count' => function () {
                return $this->request->offersCount;
            },


        ];
    }

}
