<?php

namespace api\resources\agent;


class ProfileResource extends \common\models\User
{
    public function fields()
    {
        return [
            'id',
            'user_type',
            'profile_status' => function ($model) {
                if (! preg_match( "/@testzone321/i" ,$this->email) ) {
                    return 1;
                }
                return  0;
            },               
            'email' => function ($model) {
                    return $model->email;

            },

            'firebase_token',
            'name' => function ($model) {
                return $model->full_name?:"";

            },
            'shop_name' => function ($model) {
                return $this->work->title ?: "";
            },
            'image' => function ($model) {
                return $this->userProfile->getNewAvatar() ?: "";
            },
            'joined_at' => function ($model) {
                return $model->created_at;
            },
//            'reviews_count'=> function(){
//                return 0;
//            },
            'rate' => function($model){
                return [
                    'rate_average' => $model->rate_average,
                    'total_rates' => $model->ratesCount,
                ];
            },
            'bio' => function ($model) {
                return $this->userProfile->bio ?: "";


            },

            'from_hours' => function ($model) {
                return $model->userProfile->from_hours;
            },
            'to_hours' => function ($model) {
                return $model->userProfile->to_hours;
            },
//            'mobile',
//            'rejected_status',
//            'age'=> function($model){
//                return $model->userProfile->age;
//            },
//            'location' => function ($model) {
//                return [
//                    'address' => $model->userProfile->address ?: "",
//                    'lat' => $model->userProfile->lat ?: "",
//                    'lng' => $model->userProfile->lng ?: "",
//                ];
//            },
//            'profile_type' => function($model){
//                return [
//                    'profile_type_id' =>  $model->user_type,
//                    'profile_type_text' => $model->getUserType()
//                ];
//            },
//            'status' => function ($model)
//            {
//                return $this->approval;
//            },
//            'status_text' => function ($model) {
//                return $this->approvals()[$this->approval];
//            },
//            'approval_status' => function ($model)
//            {
//                return $this->approval;
//            },
//            'approval_status_text' => function ($model) {
//                return $this->approvals()[$this->approval];
//            },

//            'all_rates' => function(){
//                return $this->rates;
//            },

        ];
    }
    /*
     *
     *  return [
                'profile_status' => function ($model) {
                    return 0;
                },
                'name' => function ($model) {
                    return $model->userProfile->firstname . ' ' . $model->userProfile->lastname;
                },

                'mobile'=>function ($model) {
                    return null;
                },
                'email'=>function ($model) {
                    return null;
                },

                'age'=> function($model){
                    return null;
                },

                'hour_rate'=> function($model){
                    return null;
                },

                "preferred_age" => function($model){
                    return [
                        'from'=>null,
                        'from_unit'=>null,
                        'to'=>null,
                        'to_unit'=>null,
                    ];
                },

                'uploaded_papers' => function ($model) {
                    return [
                        'permit' => "",
                        'national_id' =>  "",
                    ];
                },

                'uploaded_papers_status' => function ($model)
                {
                    return  1;
                },
             //   "__uploaded_papers_status__"=>" 1 not uploaded  2 uploaded",

                'profile_type' => function($model){
                    return [
                        'profile_type_id' =>  $model->user_type,
                        'profile_type_text' => $model->getUserType()
                    ];
                },

                // qualifications
                'skills' => function ($model){
                    return [];
                },

                'languages' => function ($model){
                    return [];
                },
                'education_level' => function($model){
                    return "";
                },

                'status',
                'status_text' => function ($model) {
                    return $this->statuses()[$this->status];
                },


                'approval_status' => function ($model)
                {
                    return $this->approval;
                },

                'approval_status_text' => function ($model) {
                    return $this->approvals()[$this->approval];
                },

                'balance' => function ($model) {
                    return '50';
                },
                'balance_last_update' => function ($model) {
                    return $model->created_at;
                },
                'image' => function ($model) {
                    return $this->userProfile->avatar ?: "";
                },
                'joined_at' => function ($model) {
                    return $model->created_at;
                },


            ];
     * */

}
