<?php

    namespace api\resources\nany;

    class RequestRelativeResource extends \common\models\CustomerRequestRelative
    {
        public function fields()
        {
            return [
                'id',
                'relative_name',
                'age',
                'notes'=> function ($model) {
                    return $this->notes ?: "لا يوجد";
                },
                'customer_address'=> function () {
                    return $this->user->userProfile->address?: null;
                },

                'medical_condition'=> function ($model) {
                    return $this->condition->title?: "";
                },
                'emergency_phones' => function ($model) {
                    return explode(',',$this->emergency_phones);
                },
                'created_at' => function ($model) {
                    return $model->created_at ;
                },
            ];

        }

    }
