<?php

namespace api\resources\nany;

use common\models\CustomerRequest;
use common\models\RequestLog;
use common\models\ExtendedRequests;
use api\resources\RequestTrackingLogResource;
use api\resources\RequestRateResource;

class RequestResource extends \common\models\RequestLog
{
    public function fields()
    {        
        return [
            'id',//refers to log not request
            'type',
            'created_at' => function () {
                return $this->request->created_at ;
            },
            'kids_number' => function () {
                return $this->request->allRelativesCount;
            },        
            // Request Details
            'need_to' => function(){
                return $this->request->getRequestServiceTypes()[$this->request->need_to];
            },
            'needed_role' => function(){
                return $this->request->getRequestNeededRole()[$this->request->needed_role];
            },
            'session_date' => function () {
                return $this->request->session_date;
            },
            'session_time' => function () {
                return $this->request->session_time;
            },
            'session_period' => function () {
                return $this->request->session_period;
            },
            'total_session_period' => function () {
                return $this->request->total_session_period;
            },            
            'working_place'=> function(){
                return $this->request->getWorkingPlace()[$this->request->working_place];
            },
            'relatives'=> function(){
                return $this->request->allRelatives;
            },
            'offers_count' => function () {
                return $this->request->offersCount;
            },
//            'address'=> function () {
//                return $this->request->user->userProfile->address?: null;
//            },
            // Customer main Details       
            'customer' => function () {
                return [
                    'id'=>$this->request->user_id,
                    'name'=>$this->request->user->userProfile->fullName,
                    'avatar'=>$this->request->user->userProfile->avatar,
                    'email'=>$this->request->user->email,
                    'phone'=>$this->request->user->mobile,
                    'rate_average' => $this->request->user->rate_average,
                    'total_rates' => $this->request->user->ratesCount,
                ];
            },
            'location' => function($model){
                return[                    
                    'address' => $this->request->address ?: "",
                    'lat' => $this->request->lat ?: "",
                    'lng' => $this->request->lng ?: ""
                ];
            },
            'status'=> function($model){
                return[
                    'status_id' => $this->request->status,
                    'status_text' => $this->request->statuses()[$this->status],
                ];
            },
            'amount' => function () {
                return $this->request->amount;
            },
            'added_taxes' => function () {
                return $this->request->added_taxes;
            },
            'paid_amount' => function () {
                return $this->request->paid_amount;
            },
            'nany_profit' => function () {
                return $this->request->nany_profit;
            },
            'payment_status' => function()
            {
                return [
                    'status_code' => $this->request->payment_status ,
                    'status_text' => $this->request->getPaymentStatus()[$this->request->payment_status] 
                ];
            },

            'tracking_status'=> function(){
                return [
                    'id'=>$this->request->request_tracking_status,
                    'value'=> CustomerRequest::RequestStatusTrackingList()[$this->request->request_tracking_status]
                ];
            },
            'request_tracking_log'=> function(){
                $requestLogs = RequestTrackingLogResource::find()->where(['request_id' => $this->request_id ])->all();
                return $requestLogs;
            },
            'total_rate'=> function(){
                return 0;
            },
            'raters_count'=> function(){
                return 0;
            },
            'rate' => function(){
                $requestRates = RequestRateResource::find()->where(['request_id' => $this->request_id ])->all();
                $nany = [];
                $customer = [];
                foreach($requestRates as $rate){
                    if($rate->user->user_type != 0){
                        $nany['review'] = $rate['user_review'];
                        $nany['review_stars'] = $rate['user_rating'];
                    }else{
                        $customer['review'] = $rate['user_review'];
                        $customer['review_stars'] = $rate['user_rating'];
                    }                                        
                }
                return [
                    'nany'=> (!empty($nany)) ? $nany : null,
                    'customer' => (!empty($customer)) ? $customer : null,
                ];
            },                
            'extended' => function($model){
                return $this->request->extended;
            },
            'extended_id' => function($model){
                return ($this->request->extended == CustomerRequest::STATUS_EXTENDED) ? ExtendedRequests::find()->where(['request_id' => $this->request_id ])->one()->id : null;
            },
            'location_available',
        ];
    }

}
